#ifndef DEFAULTSEQUENCE_H
#define DEFAULTSEQUENCE_H

#include <boost/shared_ptr.hpp>

#include "../ipc/SequenceRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/TestRequest.h"
#include "../ipc/Sct_CalibrationController.hh"
#include <iostream>

using namespace std;
using namespace boost;

namespace SctCalibrationController {
    
using namespace Ipc;

namespace Scripts {
    
class DefaultSequence : public SequenceRequestImpl {
public:	
    DefaultSequence(shared_ptr<TestRequest> r) : request(r){}
        
    virtual string startSequence(Sct_SctApi_T_SctApi& api) {
	return "DefaultSequence";
    }
    
    virtual TestRequest* getNextTest(unsigned long index) {
	if (index == 0) return request.get();
	else return 0;
    }
    
    virtual void endSequence() {}

private:
    shared_ptr<TestRequest> request;
};
}
}
#endif //DEFAULTSEQUENCE_H
