#ifndef TESTREQUEST_H
#define TESTREQUEST_H

#include "Sct_CalibrationController.hh"
#include "ScanRequest.h"
#include <ipc/object.h>
#include <memory>
#include <string>
#include <vector>

using std::vector;
using std::auto_ptr;
using std::string;

namespace SctCalibrationController {
namespace Ipc {
    
class CalibrationController;
    
/**
  See the documentation in CalibrationController.idl for these methods.
  All may throw RequestException.  This is the nice interface
  */
class TestRequest {
public:	    
    virtual ~TestRequest() {}
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) = 0;
    virtual ScanRequest* getNextScan(unsigned long index) = 0;
    virtual bool canFeedback() = 0;
    virtual void endTest() = 0;    
};

/**
  This is the internal implementation - to be derived from!
  */
class TestRequestImpl : public IPCCallback, public virtual Sct_CalibrationController_T_TestRequest, public virtual TestRequest {
public:    
    TestRequestImpl();
    virtual void startTest (Sct_CalibrationControllerStatus *_status, Sct_SctApi_T_SctApi * api, ilu_T_CString * name, ilu_ShortCardinal * testVariable, ilu_Cardinal * nScans, Sct_CalibrationController_T_TestPoints testPointsData);
    virtual Sct_CalibrationController_T_ScanRequest* getNextScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal index);    
    virtual ilu_Boolean canFeedback (Sct_CalibrationControllerStatus *_status);
    virtual void endTest (Sct_CalibrationControllerStatus *_status);
};

/**
  This is the adapter for external implementations.
  These calls may fail and throw RequestExceptions
  */
class TestRequestAdapter : public virtual TestRequest {
public:
    TestRequestAdapter(Sct_CalibrationController_T_TestRequest* req);
    /**
      throws IpcException if any of the out variables are not set in the call
      */
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) ;
    virtual ScanRequest* getNextScan(unsigned long index);
    virtual bool canFeedback();
    virtual void endTest();
    
private:
    Sct_CalibrationController_T_TestRequest* request;
};

}
}
#endif //TESTREQUEST_H
