#include "TestRequest.h"
#include "CalibrationController.h"
#include "RequestException.h"

namespace SctCalibrationController {
namespace Ipc {
    
TestRequestImpl::TestRequestImpl() : IPCCallback(&CalibrationController::getServer()) {
}

void TestRequestImpl::startTest (Sct_CalibrationControllerStatus *_status, Sct_SctApi_T_SctApi * api, ilu_T_CString * name, ilu_ShortCardinal * testVariable, ilu_Cardinal * nScans, Sct_CalibrationController_T_TestPoints testPointsData){
}

Sct_CalibrationController_T_ScanRequest* TestRequestImpl::getNextScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal index){
    return 0;
}

ilu_Boolean TestRequestImpl::canFeedback (Sct_CalibrationControllerStatus *_status) {
    return false;
}

void TestRequestImpl::endTest (Sct_CalibrationControllerStatus *_status) {
}


TestRequestAdapter::TestRequestAdapter(Sct_CalibrationController_T_TestRequest* req) : request(req) {
}


void TestRequestAdapter::startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, 
				   unsigned long& nScans, vector<double>& testPoints) {
    Sct_CalibrationControllerStatus status;
    char* text = 0;
    _Sct_CalibrationController_T_TestPoints_sequence data;
    request->startTest(&status, &api, &text, &testVariable, &nScans, &data);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "TestRequestAdapter::startTest failed", __FILE__, __LINE__);
    name = text;
    for (unsigned int i = 0; i<data.Length(); ++i) {
	testPoints.push_back(data.Nth(i));
    }
    delete [] text;
}

ScanRequest* TestRequestAdapter::getNextScan(unsigned long index) {
    Sct_CalibrationControllerStatus status;
    Sct_CalibrationController_T_ScanRequest* scan = request->getNextScan(&status, index);
    if (status.returnCode != 0) 
      throw RequestException(status.returnCode, "TestRequestAdapter::getNextScan failed", __FILE__, __LINE__);    
    if (scan==0) return 0;
    ScanRequest* ptr=dynamic_cast<ScanRequest*>(scan);
    if (ptr!=0) return ptr;
    else return new ScanRequestAdapter(scan);
}

bool TestRequestAdapter::canFeedback() {
    Sct_CalibrationControllerStatus status;   
    bool can = request->canFeedback(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "TestRequestAdapter::canFeedback failed", __FILE__, __LINE__);    
    return can;
}

void TestRequestAdapter::endTest() {
    Sct_CalibrationControllerStatus status;
    request->endTest(&status);    
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "TestRequestAdapter::endTest failed", __FILE__, __LINE__);    
}

    
}
}
