#include "TestLibrary.h"
#include "TestRequest.h"
#include "CalibrationController.h"

namespace SctCalibrationController {
namespace Ipc {
    
TestLibrary::TestLibrary() : IPCCallback(&CalibrationController::getServer()) {
    cout << "create TestLibrary" << endl;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::responseCurve (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = responseCurve();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::threePointGain (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = threePointGain();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::strobeDelay (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = strobeDelay();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::noiseOccupancy (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = noiseOccupancy();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::pipeline (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = pipeline();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::fullBypassBarrel (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = fullBypassBarrel();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::fullBypassEndcap (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = fullBypassEndcap();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::trimRange (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = trimRange();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::timeWalk (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = timeWalk();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::nmask (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = nmask();
    req.incRef();
    return &req;
}


Sct_CalibrationController_T_TestRequest * TestLibrary::rxDelay (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = rxDelay();
    req.incRef();
    return &req;
}

Sct_CalibrationController_T_TestRequest * TestLibrary::rxThreshold (Sct_CalibrationControllerStatus *_status) {
    TestRequestImpl& req = rxThreshold();
    req.incRef();
    return &req;
}

}
}
