#ifndef SEQUENCEREQUEST_H
#define SEQUENCEREQUEST_H

#include "Sct_CalibrationController.hh"
#include <ipc/object.h>
#include <memory>
#include <string>

using std::string;
using std::auto_ptr;

namespace SctCalibrationController {
namespace Ipc {
    
class CalibrationController;
class TestRequest;

/**
  See the documentation in CalibrationController.idl for these methods.
  All may throw RequestException.  This is the nice interface
  */
class SequenceRequest {
public:
    virtual ~SequenceRequest() {}
    virtual string startSequence(Sct_SctApi_T_SctApi& api) = 0;
    virtual TestRequest* getNextTest(unsigned long index) = 0;
    virtual void endSequence() = 0;    
};

/**
  This is the internal implementation - to be derived from!
  */
class SequenceRequestImpl : public IPCCallback, public virtual Sct_CalibrationController_T_SequenceRequest, public virtual SequenceRequest{
public:	    
    SequenceRequestImpl();
    virtual ilu_T_CString startSequence (Sct_CalibrationControllerStatus *_status, Sct_SctApi_T_SctApi * api);
    virtual class Sct_CalibrationController_T_TestRequest * getNextTest (Sct_CalibrationControllerStatus *_status, ilu_Cardinal index);
    virtual void endSequence (Sct_CalibrationControllerStatus *_status);
};

/**
  This is the adapter for external implementations.
  These calls may fail and throw RequestExceptions
  */
class SequenceRequestAdapter : public virtual SequenceRequest {
public:
    SequenceRequestAdapter(Sct_CalibrationController_T_SequenceRequest* req);    
    
    virtual string startSequence(Sct_SctApi_T_SctApi& api);
    virtual TestRequest* getNextTest(unsigned long index);
    virtual void endSequence();
    
private:
    Sct_CalibrationController_T_SequenceRequest* request;
};

}
}
#endif //SEQUENCEREQUEST_H
