#include "RequestException.h"
#include "SequenceRequest.h"
#include "CalibrationController.h"
#include "TestRequest.h"

namespace SctCalibrationController {
namespace Ipc {
    
SequenceRequestImpl::SequenceRequestImpl() : IPCCallback(&CalibrationController::getServer()) {
}

ilu_T_CString SequenceRequestImpl::startSequence (Sct_CalibrationControllerStatus *_status, Sct_SctApi_T_SctApi * api) {
    cout << "SequenceRequestImpl::startSequenece" << endl;
    char* str = new char[0];
    return str;
}

Sct_CalibrationController_T_TestRequest * SequenceRequestImpl::getNextTest (Sct_CalibrationControllerStatus *_status, ilu_Cardinal index) {
    return 0;
}

void SequenceRequestImpl::endSequence (Sct_CalibrationControllerStatus *_status) {
}

SequenceRequestAdapter::SequenceRequestAdapter(Sct_CalibrationController_T_SequenceRequest* req) : request(req) {
}

string SequenceRequestAdapter::startSequence(Sct_SctApi_T_SctApi& api) {
    cout << "SequenceRequestAdapter::startSequence "<<endl;
    Sct_CalibrationControllerStatus status;
    char* str = 0;
    str = request->startSequence(&status, &api);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "SequenceRequestAdapter::startSequence failed", __FILE__, __LINE__);    
    
    string st = str;
    delete [] str;
    return st;
}

TestRequest* SequenceRequestAdapter::getNextTest(unsigned long index) {
    Sct_CalibrationControllerStatus status;
    Sct_CalibrationController_T_TestRequest* tr = request->getNextTest(&status, index);    
    
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "SequenceRequestAdapter::getNextTest failed", __FILE__, __LINE__);    
    
    if (tr == 0) return 0;
    TestRequest* ptr = dynamic_cast<TestRequest*>(tr);
    if (ptr != 0) return ptr;
    else return new TestRequestAdapter(tr);
}

void SequenceRequestAdapter::endSequence() {
    Sct_CalibrationControllerStatus status;
    request->endSequence(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "SequenceRequestAdapter::endSequence failed", __FILE__, __LINE__);        
}


}
}
