#ifndef SCTCALIBRATIONCONTROLLER_SCANREQUEST_H
#define SCTCALIBRATIONCONTROLLER_SCANREQUEST_H

#include "Sct_CalibrationController.hh"
#include <ipc/object.h>
#include <memory>
#include <string>
#include <vector>

using std::vector;
using std::auto_ptr;
using std::string;

namespace SctCalibrationController {
namespace Ipc {
    
class CalibrationController;
    
/**
  See the documentation in CalibrationController.idl for these methods.
  All may throw RequestException.  This is the nice interface
  */
class ScanRequest {
public:	    
    virtual ilu_Boolean isRaw()=0;
    virtual ilu_Boolean configureModules()=0;
    virtual long delay()=0;
    virtual void setScan(Sct_SctApi_T_Scan* s)=0;
    virtual ilu_Boolean clockByTwo()=0;
    virtual void setClockByTwo(ilu_Boolean value)=0;
    virtual long width()=0;
    virtual void setWidth(long value)=0;
    virtual Sct_SctApi_T_Scan* getScan()=0;
};

/**
  This is the internal implementation, to be derived from;
  */
class ScanRequestImpl : public IPCCallback, public virtual Sct_CalibrationController_T_ScanRequest, public virtual ScanRequest {
public:    
    ScanRequestImpl();
    virtual ilu_Boolean isRaw(Sct_CalibrationControllerStatus *_status);
    virtual ilu_Boolean configureModules(Sct_CalibrationControllerStatus *_status);
    virtual ilu_Boolean clockByTwo(Sct_CalibrationControllerStatus *_status);
    virtual long delay(Sct_CalibrationControllerStatus *_status);
    virtual Sct_SctApi_T_Scan* getScan (Sct_CalibrationControllerStatus *_status);
    virtual void setScan (Sct_CalibrationControllerStatus *_status, Sct_SctApi_T_Scan* scan);
    virtual void setClockByTwo (Sct_CalibrationControllerStatus *_status, ilu_Boolean value);
    virtual long width(Sct_CalibrationControllerStatus *_status);
    virtual void setWidth(Sct_CalibrationControllerStatus *_status, long width);

    virtual ilu_Boolean isRaw();
    virtual ilu_Boolean configureModules();
    virtual ilu_Boolean clockByTwo();
    virtual void setClockByTwo(ilu_Boolean value);
    virtual long width();
    virtual void setWidth(long width);
    virtual long delay();
    virtual void setScan(Sct_SctApi_T_Scan* s);
    virtual Sct_SctApi_T_Scan* getScan ();
 protected:
    bool m_clockByTwo;
    long m_width;
    Sct_SctApi_T_Scan* m_scan;  
};

/**
  This is the adapter for external implementations.
  These calls may fail and throw RequestExceptions
  */
class ScanRequestAdapter : public virtual ScanRequest {
public:
    ScanRequestAdapter(Sct_CalibrationController_T_ScanRequest* req);
    virtual ilu_Boolean isRaw();
    virtual ilu_Boolean configureModules();
    virtual ilu_Boolean clockByTwo();
    virtual long delay();
    virtual void setScan(Sct_SctApi_T_Scan* s);
    virtual Sct_SctApi_T_Scan* getScan();
    virtual void setClockByTwo(ilu_Boolean value);
    virtual long width();
    virtual void setWidth(long width);
private:
    Sct_CalibrationController_T_ScanRequest* request;
};

}
}
#endif //SCTCALIBRATIONCONTROLLER_SCANREQUEST_H
