#include "ScanRequest.h"
#include "CalibrationController.h"
#include "RequestException.h"

namespace SctCalibrationController {
namespace Ipc {
    
  ScanRequestImpl::ScanRequestImpl() : IPCCallback(&CalibrationController::getServer()),
				       m_clockByTwo(false), m_width(768){
}

ilu_Boolean ScanRequestImpl::isRaw(Sct_CalibrationControllerStatus *_status) {
  return isRaw();
}

ilu_Boolean ScanRequestImpl::clockByTwo(Sct_CalibrationControllerStatus *_status) {
  return clockByTwo();
}

ilu_Boolean ScanRequestImpl::clockByTwo() {
  return m_clockByTwo;
}

long ScanRequestImpl::width() {
  return m_width;
}

void ScanRequestImpl::setWidth(long value) {
  m_width=value;
}

long ScanRequestImpl::width(Sct_CalibrationControllerStatus *_status) {
  return width();
}

void ScanRequestImpl::setWidth(Sct_CalibrationControllerStatus *_status, long value) {
  setWidth(value);
}

void ScanRequestImpl::setClockByTwo(Sct_CalibrationControllerStatus *_status, ilu_Boolean value) {
  setClockByTwo(value);
}

void ScanRequestImpl::setClockByTwo(ilu_Boolean value) {
  m_clockByTwo=value;
}

ilu_Boolean ScanRequestImpl:: configureModules(Sct_CalibrationControllerStatus *_status){
  return configureModules();
}

ilu_Boolean ScanRequestImpl::configureModules(){
  return false;
}

long ScanRequestImpl::delay(Sct_CalibrationControllerStatus *_status){
  return delay();
}

long ScanRequestImpl::delay(){
  return 1;
}

Sct_SctApi_T_Scan* ScanRequestImpl::getScan(){
  m_scan->incRef();
  return m_scan;
}

Sct_SctApi_T_Scan* ScanRequestImpl::getScan(Sct_CalibrationControllerStatus *_status){
  return getScan();
}

void ScanRequestImpl::setScan(Sct_SctApi_T_Scan* scan){
  m_scan=scan;
}

ilu_Boolean ScanRequestImpl::isRaw(){
  return false;
}

void ScanRequestImpl::setScan(Sct_CalibrationControllerStatus *_status, Sct_SctApi_T_Scan* scan){
  setScan(scan);
}

ScanRequestAdapter::ScanRequestAdapter(Sct_CalibrationController_T_ScanRequest* req) : request(req) {
}

ilu_Boolean ScanRequestAdapter::configureModules() {
    Sct_CalibrationControllerStatus status;
    ilu_Boolean config = request->configureModules(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::configureModules failed", __FILE__, __LINE__);    
    return config;
}

ilu_Boolean ScanRequestAdapter::clockByTwo() {
    Sct_CalibrationControllerStatus status;
    ilu_Boolean config = request->clockByTwo(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::clockByTwo failed", __FILE__, __LINE__);    
    return config;
}

void ScanRequestAdapter::setClockByTwo(ilu_Boolean value) {
    Sct_CalibrationControllerStatus status;
    request->setClockByTwo(&status, value);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::setClockByTwo failed", __FILE__, __LINE__);    
}

ilu_Boolean ScanRequestAdapter::isRaw() {
    Sct_CalibrationControllerStatus status;
    ilu_Boolean raw = request->isRaw(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::setConfigureModules failed", __FILE__, __LINE__);    
    return raw;
}

long ScanRequestAdapter::delay() {
    Sct_CalibrationControllerStatus status;
    long delay = request->configureModules(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::setConfigureModules failed", __FILE__, __LINE__);    
    return delay;
}

long ScanRequestAdapter::width() {
    Sct_CalibrationControllerStatus status;
    long width = request->width(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::setConfigureModules failed", __FILE__, __LINE__);    
    return width;
}

void ScanRequestAdapter::setWidth(long width) {
    Sct_CalibrationControllerStatus status;
    request->setWidth(&status, width);
    if (status.returnCode != 0) 
      throw RequestException(status.returnCode, "ScanRequestAdapter::setConfigureModules failed", __FILE__, __LINE__);    
}

Sct_SctApi_T_Scan* ScanRequestAdapter::getScan() {
  Sct_CalibrationControllerStatus status;
  Sct_SctApi_T_Scan* scan = request->getScan(&status);
    if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::getScan failed", __FILE__, __LINE__);
  return scan;
}

void ScanRequestAdapter::setScan(Sct_SctApi_T_Scan* scan) {
  Sct_CalibrationControllerStatus status;
  request->setScan(&status, scan);
  if (status.returnCode != 0) 
	throw RequestException(status.returnCode, "ScanRequestAdapter::setScan failed", __FILE__, __LINE__);
}

}
}
