#ifndef IPC_CALIBRATIONCONTROLLER_H
#define IPC_CALIBRATIONCONTROLLER_H

#include "Sct_CalibrationController.hh"
#include <ipc/object.h>
#include <memory>
#include <vector>
#include <boost/shared_ptr.hpp>

using namespace std;
using boost::shared_ptr;

namespace SctCalibrationController {
namespace Ipc {

class ScanRequest;
class ScanLibrary;   
class TestLibrary;
class SequenceLibrary;
class TestSequence;
class TestRequest;
class SequenceRequest;	

/**
   Maps ILU-IPC requests onto the nicer pure virtual interface. 
*/
    
class CalibrationController : public IPCObject, public virtual Sct_CalibrationController_T_CalibrationController {
public:
    Sct_CalibrationController_T_ScanLibrary * getScanLibrary (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestLibrary * getTestLibrary (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_SequenceLibrary * getSequenceLibrary (Sct_CalibrationControllerStatus *_status);
    void doScan (Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_ScanRequest* s);
    void doTest (Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_TestRequest *t);
    void doSequence (Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_SequenceRequest * r);
    void abort (Sct_CalibrationControllerStatus *_status);
    Sct_SctApi_T_Scan * getScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal runNumber, ilu_Cardinal scanNumber);
    void setUpdateOption(Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_CalibrationController_UpdateOption);

virtual void updateWith (Sct_CalibrationControllerStatus *_status, ilu_T_CString testResultInIs);
    
    static IPCServer& getServer();
    
    //New pure functions - the nice interface!
    
    virtual ScanLibrary& getScanLibrary() const = 0;
    virtual TestLibrary& getTestLibrary() const = 0;
    virtual SequenceLibrary& getSequenceLibrary() const = 0;
    virtual void doScan (shared_ptr<ScanRequest> s) = 0;
    virtual void doTest (shared_ptr<TestRequest> t) = 0;
    virtual void doSequence(shared_ptr<SequenceRequest> r) = 0;
    virtual void abort() = 0;
    virtual Sct_SctApi_T_Scan* getScan(unsigned long runNumber, unsigned long scanNumber) const = 0;
    virtual void setUpdateOption(Sct_CalibrationController_T_CalibrationController_UpdateOption opt) =0;
    virtual void updateWith (ilu_T_CString testResultInIs)=0;
protected:
    CalibrationController();
    virtual ~CalibrationController();
};
}
}
#endif //#ifndef CALIBRATIONCONTROLLER_H
