#include "CalibrationController.h"
#include "ScanLibrary.h"
#include "TestLibrary.h"
#include "SequenceLibrary.h"
#include "SequenceRequest.h"
#include "TestRequest.h"
#include "Sct/SctNames.h"
#include <ipc/server.h>

#include <iostream>

using namespace std;
using namespace Sct;

namespace SctCalibrationController {
namespace Ipc {
    
CalibrationController::CalibrationController() : IPCObject(Sct_CalibrationController_C_CalibrationController_instanceName, &getServer()) {
    cout << "CalibrationController::CalibrationController()" << endl;
}

CalibrationController::~CalibrationController() {
    cout << "CalibrationController::~CalibrationController()" << endl;
}

IPCServer& CalibrationController::getServer() {
    static IPCServer server (Sct_CalibrationController_C_CalibrationController_serverName, SctNames::getPartition());
    return server;
}

Sct_CalibrationController_T_ScanLibrary* CalibrationController::getScanLibrary (Sct_CalibrationControllerStatus *_status) {
    cout << "External get Scan library" << endl;
    ScanLibrary& sl = getScanLibrary();
    sl.incRef();
    return &sl;
}

Sct_CalibrationController_T_TestLibrary* CalibrationController::getTestLibrary (Sct_CalibrationControllerStatus *_status) {
    cout << "External get Test library" << endl;
    TestLibrary& tl = getTestLibrary();
    tl.incRef();
    return &tl;
}

Sct_CalibrationController_T_SequenceLibrary * CalibrationController::getSequenceLibrary (Sct_CalibrationControllerStatus *_status) {
    cout << "External Get Sequence Library" << endl;
    SequenceLibrary& sl = getSequenceLibrary();
    sl.incRef();
    return &sl;
}

//We need a null deleter for the internal XXXRequest objects

template<typename T>
class NullDeleter {
public:
    void operator() (T* t) throw () {}
};

void CalibrationController::updateWith (Sct_CalibrationControllerStatus *_status, ilu_T_CString testResultInIs){
  updateWith(testResultInIs);
}

void CalibrationController::doScan (Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_ScanRequest * s) {
  shared_ptr<ScanRequest> req (dynamic_cast<ScanRequest*>(s), NullDeleter<ScanRequest>());
  if (!req) {
    req = shared_ptr<ScanRequest>(new ScanRequestAdapter(s));
  }
  doScan(req);
}

void CalibrationController::setUpdateOption(Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_CalibrationController_UpdateOption opt){
    setUpdateOption(opt);
}

void CalibrationController::doTest (Sct_CalibrationControllerStatus *_status, class Sct_CalibrationController_T_TestRequest *t) {
    shared_ptr<TestRequest> req (dynamic_cast<TestRequest*>(t), NullDeleter<TestRequest>());
    if (!req) {
	req = shared_ptr<TestRequest>(new TestRequestAdapter(t));
    }
    
    doTest(req); 
}

void CalibrationController::doSequence (Sct_CalibrationControllerStatus *_status, class Sct_CalibrationController_T_SequenceRequest * r) {
    shared_ptr<SequenceRequest> req (dynamic_cast<SequenceRequest*>(r), NullDeleter<SequenceRequest>());
    if (!req) {
	req = shared_ptr<SequenceRequest>(new SequenceRequestAdapter(r));
    }
    doSequence(req);
}

void CalibrationController::abort (Sct_CalibrationControllerStatus *_status) {
    abort();
}

Sct_SctApi_T_Scan * CalibrationController::getScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal runNumber, ilu_Cardinal scanNumber) {
    return getScan(runNumber, scanNumber);
}

}
}
