#ifndef TESTLIBRARYIMPL_H
#define TESTLIBRARYIMPL_H

#include "ipc/TestLibrary.h"
#include <boost/utility.hpp>
#include <ipc/object.h>

namespace SctCalibrationController {
using namespace Ipc;
    
class TestLibraryImpl : public TestLibrary {
public:
    static TestLibraryImpl& instance();
    
    virtual TestRequestImpl& responseCurve() const;
    virtual TestRequestImpl& threePointGain() const;
    virtual TestRequestImpl& strobeDelay() const;    
    virtual TestRequestImpl& noiseOccupancy() const;
    virtual TestRequestImpl& pipeline() const;
    virtual TestRequestImpl& fullBypassBarrel() const;
    virtual TestRequestImpl& fullBypassEndcap() const;
    virtual TestRequestImpl& trimRange() const;
    virtual TestRequestImpl& timeWalk() const;
    virtual TestRequestImpl& nmask() const;

     virtual TestRequestImpl& rxDelay() const;
     virtual TestRequestImpl& rxThreshold() const;
private:
    TestLibraryImpl();
};
    
}

#endif //TESTLIBRARYIMPL_H
