#ifndef SCT_CC_SEQUENCEREQUESTWORKER_H
#define SCT_CC_SEQUENCEREQUESTWORKER_H
#include "CalibrationControllerImpl.h"
#include <boost/shared_ptr.hpp>

using boost::shared_ptr;

namespace SctCalibrationController {

    /** 
	object created by CalibrationControllerImpl when a new sequence is requested.
	thread calls operator() () which 
    */
    class SequenceRequestWorker{
    public:
	/// constructor takes reference to its CalibrationControllerImpl parent and the SequenceRequest it is to follow.
	SequenceRequestWorker(CalibrationControllerImpl& c, shared_ptr<Ipc::SequenceRequest> r) :
	    m_cc(c), m_sr(r)  {;}

	/// Called by new thread. @note does not throw.
	void operator () () ;
	/// does nothing.
	~SequenceRequestWorker() {;}
    private:
	SequenceRequestWorker();
	/// reference to it's `parent' CalibrationControllerImpl
	CalibrationControllerImpl& m_cc;
	/// reference to the Sequence.
	shared_ptr<Ipc::SequenceRequest> m_sr;
    };
    
} // end of namespace SctCalibrationController

#endif
