#include "SequenceRequestWorker.h"
#include "Sct/Exception.h"
#include "Sct/StdExceptionWrapper.h"

namespace SctCalibrationController {

    void SequenceRequestWorker::operator () (){  // does not throw
	Sct::Throwable* mrs = 0;
	try {
	    cout << "In SequenceRequestWorker operator ()" << endl;
	    m_cc.executeSequence(*m_sr);
	    m_cc.status.status = m_cc.status.INCONTROL;  // was originally set to BUSY by CalibrationControllerImpl.
	    m_cc.updateStatus();
	    cout << "End of SequenceRequestWorker operator()" << endl;
	} catch(Sct::Throwable &e) {
	    e.sendToMrs(MRS_ERROR);
	} catch(std::exception &e) {
	    mrs = new Sct::StdExceptionWrapper(e);
	} catch(std::string &s) {          // Just in case	
	    std::ostringstream os;
	    os<<"uncaught string expection "<<s;
	    mrs = new Sct::Error(os.str(), __FILE__, __LINE__);
	} catch(...) {
	    mrs = new Sct::Error("uncaught unknown exception", __FILE__, __LINE__);
	}
	if (mrs) {
	    mrs->sendToMrs(MRS_ERROR);
	}
    }
}
