#include "SequenceMap.h"
#include "Sequence.h"

#include <iostream>
using namespace std;

namespace SctCalibrationController {
    
SequenceMap::SequenceMap() throw() {
}

SequenceMap& SequenceMap::instance() throw() {
    static SequenceMap map;
    return map;
}
    
weak_ptr<Sequence> SequenceMap::getSequence(const string& name) throw() {
    if (map.count(name) == 0) return weak_ptr<Sequence>();
    SequenceMapData& d = (*map.find(name)).second;
    d.lastRequested = time(0);
    
    return weak_ptr<Sequence>(d.sequence);
}

void SequenceMap::addSequence(shared_ptr<Sequence> sequence) throw() {
    purge();
    SequenceMapData d;
    d.sequence = sequence;
    map[sequence->getUniqueID()] = d;
    cout << "Sequence added" << endl;
}

//Only remove objects if there are more than 10 of them!
//Remove at most 1!
void SequenceMap::purge() throw() {
    if (map.size() < 10) return;
    
    for (DataMap::iterator i = map.begin(); i!=map.end(); ++i) {
	SequenceMapData& d = (*i).second;
	time_t now = time(0);
	if (difftime(now, d.lastRequested) > 3600 && d.sequence.unique()) {
	    remove(i);
	    return;
	}
    }
  
    //For some reason we couldn't remove any of them - remove the oldest!
    if (map.size() < 20) return;
 
    DataMap::iterator oldest = map.begin();
    for (DataMap::iterator i = ++map.begin(); i!=map.end(); ++i) {
	SequenceMapData& d = (*i).second;
	SequenceMapData& old = (*oldest).second;
	if (d.lastRequested < old.lastRequested) {
	    oldest = i;
	}
    }
    remove(oldest);
}

void SequenceMap::remove(DataMap::iterator& i) throw() {
    cout << "Removing element from SequenceMap: " << (*i).second.sequence->getUniqueID() << endl;
    map.erase(i);
    
}

SequenceMap::SequenceMapData::SequenceMapData() throw(): 
    created(time(&created)), lastRequested(time(&lastRequested)) {
}

}
