#ifndef SCTCALIBRATIONCONTROLLER_SCTAPIEXCEPTION_H
#define SCTCALIBRATIONCONTROLLER_SCTAPIEXCEPTION_H

#include "Sct/IpcException.h"

namespace SctCalibrationController {

/**
 * Thrown when SctApi reports an error
 * @ingroup Exceptions
 * @author Matthew Palmer
 */
class SctApiException : public Sct::IpcException {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    SctApiException(const ilu_Exception& error, const string& msg, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("SCTAPI_EXCEPTION", "CalibrationController::SctApiException", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    SctApiException(const ilu_Exception& error, Throwable& cause, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("SCTAPI_EXCEPTION", "CalibrationController::SctApiException", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    SctApiException(const ilu_Exception& error, const string& msg, Throwable& cause, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("SCTAPI_EXCEPTION", "CalibrationController::SctApiException", msg, &cause, file, line);
    }
        
protected:
    SctApiException() throw() {}
};
}
#endif //SCTCALIBRATIONCONTROLLER_SCTAPIEXCEPTION_H
