#include "TrimRangeConfigUpdater.h"
#include "ConfigUpdaterManager.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/SctParameters.h"
#include "Sct/SctNames.h"
#include "Sct/OutOfRangeError.h"
#include "SctData/TrimRangeTestResult.h"
#include "SctData/DefectPrototype.h"
#include "CommonWithDsp/ABCD/ABCDscans.h"

using namespace SctData;
using namespace Sct;

namespace SctCalibrationController {

bool TrimRangeConfigUpdater::inMap = ConfigUpdaterManager::instance().setUpdater("SctData::TrimRangeTestResult", shared_ptr<TrimRangeConfigUpdater> (new TrimRangeConfigUpdater() ) );

void TrimRangeConfigUpdater::update(const TestResult& testresult, Sct_SctApi_T_SctApi& api) const {
    const TrimRangeTestResult& t = dynamic_cast<const TrimRangeTestResult&> (testresult) ;
    unsigned long mid = getMID(t, api);
    short trims[nChannelModule];

    if (t.chipTrim.size()!=Sct::nChipModule) {
	throw Sct::OutOfRangeError<int>("Wrong number of chip trims!", __FILE__, __LINE__, t.chipTrim.size(), Sct::nChipModule, Sct::nChipModule);
    }

    for (unsigned ichip=0; ichip<Sct::nChipModule; ++ichip) {
         if (t.chipTrim[ichip].get()){
	     unsigned int range = t.chipTrim[ichip]->range;
	     float target = t.chipTrim[ichip]->target;
	     SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT("CalibrationController updating trim target and range") 
		             << MRS_PARAM<long>("ModuleID", mid) << MRS_PARAM<long>("Chip", ichip) 
			     << MRS_PARAM<int>("Range", range) << MRS_PARAM<float>("Target(mV)", target) 
			     << MRS_INFORMATION << ENDM;
	     APICALL(&api, modifyABCDChipVar(&st, mid, ichip, ST_TRIM_RANGE, range), "TrimRangeConfigUpdater failed to set trim range")
	     APICALL(&api, modifyABCDChipVar(&st, mid, ichip, ST_TARGET, target), "TrimRangeConfigUpdater failed to set trim range")
	 } else {
	     std::ostringstream oss;
	     oss << "CalibrationController could not update trim range for chip " << ichip;
	     SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT(oss.str().c_str()) 
		             << MRS_PARAM<long>("ModuleID", mid)  << MRS_PARAM<long>("Chip#", ichip) 
			     << MRS_DIAGNOSTIC << ENDM;
	     continue;
	}
	for (unsigned ichannel=0; ichannel < nChannelChip; ++ ichannel){
	    unsigned channelInModule=ichip*nChannelChip+ichannel;
	    
	    assert(channelInModule<Sct::nChannelModule);
	    
	    if (t.chipTrim[ichip]->channelTrim.getAt(ichannel).valid){
		trims[channelInModule] =  t.chipTrim[ichip]->channelTrim.getAt(ichannel).value.trim ;
	    }else{
		trims[channelInModule] = 8;
	    }
	}	
    }
    
    SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT("CalibrationController updating trims") << MRS_PARAM<long>("ModuleID", mid) << MRS_INFORMATION << ENDM;
    Sct_SctApi_T_CharBlock data = _Sct_SctApi_T_CharBlock_sequence::Create(nChannelModule, trims);
    APICALL(&api, modifyABCDTrims(&st, mid, data), "TrimRangeConfigUpdater failed to set trims")

    maskChannels(t, UNUSEABLE, api);
}		

}
