#include "StrobeDelayConfigUpdater.h"
#include "ConfigUpdaterManager.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/SctParameters.h"
#include "Sct/SctNames.h"
#include "SctData/StrobeDelayTestResult.h"
#include "CommonWithDsp/ABCD/ABCDscans.h"

using namespace Sct;
using namespace SctData;

namespace SctCalibrationController {

bool StrobeDelayConfigUpdater::inMap = ConfigUpdaterManager::instance().setUpdater("SctData::StrobeDelayTestResult", shared_ptr<ConfigUpdater> (new StrobeDelayConfigUpdater()));

void StrobeDelayConfigUpdater::update(const TestResult& testresult, Sct_SctApi_T_SctApi& api) const {
    const StrobeDelayTestResult& t = dynamic_cast<const StrobeDelayTestResult&> (testresult);
    unsigned long mid = getMID(t, api);
    SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT("CalibrationController updating StrobeDelay") << MRS_PARAM<long>("ModuleID", mid) << MRS_DIAGNOSTIC << ENDM;

    if (t.getNOptima()!=Sct::nChipModule) {
	    Sct::SctNames::Mrs() << "CC_NO_UPDATE" << MRS_TEXT("Wrong data format in StrobeDelayConfigUpdater") << MRS_ERROR << ENDM; 
            return;
    }
    for (unsigned ichip=0; ichip<Sct::nChipModule; ++ichip) {
        APICALL(&api, modifyABCDChipVar(&st, mid, ichip, ST_STROBE_DELAY, (double)t.getOptimum(ichip)), "StrobeDelayConfigUpdater failed to set delay")
    }
}
    
}
