#include "RxThresholdConfigUpdater.h"
#include "ConfigUpdaterManager.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/SctParameters.h"
#include "Sct/SctNames.h"
#include "SctData/RxThresholdTestResult.h"
#include "CommonWithDsp/ABCD/ABCDscans.h"
#include "SctApi/utility.h"

using namespace Sct;
using namespace SctData;

namespace SctCalibrationController {

bool RxThresholdConfigUpdater::inMap = ConfigUpdaterManager::instance().setUpdater("SctData::RxThresholdTestResult", shared_ptr<ConfigUpdater> (new RxThresholdConfigUpdater()));

void RxThresholdConfigUpdater::update(const TestResult& testresult, Sct_SctApi_T_SctApi& api) const {
    const RxThresholdTestResult& t = dynamic_cast<const RxThresholdTestResult&> (testresult);
    unsigned long mid = getMID(t, api);
    SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT("CalibrationController updating RxThreshold") << MRS_PARAM<long>("ModuleID", mid) << MRS_DIAGNOSTIC << ENDM;

    unsigned partition, crate, rod, channel;
    SctApi::Utility::getpcrc(mid, partition, crate, rod, channel);

    APICALL(&api, modifyBOCParam(&st, partition, crate, rod, channel, ST_RX_THRESHOLD0, (int)floor(t.getOptimum(0)+0.5)), "RxDelayConfigUpdater failed to set delay")
    APICALL(&api, modifyBOCParam(&st, partition, crate, rod, channel, ST_RX_THRESHOLD1, (int)floor(t.getOptimum(1)+0.5)), "RxDelayConfigUpdater failed to set delay")
}
    
}
