#include "RxDelayConfigUpdater.h"
#include "ConfigUpdaterManager.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/SctParameters.h"
#include "Sct/SctNames.h"
#include "SctData/RxDelayTestResult.h"
#include "CommonWithDsp/ABCD/ABCDscans.h"
#include "SctApi/utility.h"

using namespace Sct;
using namespace SctData;

namespace SctCalibrationController {

bool RxDelayConfigUpdater::inMap = ConfigUpdaterManager::instance().setUpdater("SctData::RxDelayTestResult", shared_ptr<ConfigUpdater> (new RxDelayConfigUpdater()));

void RxDelayConfigUpdater::update(const TestResult& testresult, Sct_SctApi_T_SctApi& api) const {
    const RxDelayTestResult& t = dynamic_cast<const RxDelayTestResult&> (testresult);
    unsigned long mid = getMID(t, api);
    SctNames::Mrs() << "CC_UPDATE" << MRS_TEXT("CalibrationController updating RxDelay") << MRS_PARAM<long>("ModuleID", mid) << MRS_DIAGNOSTIC << ENDM;

    unsigned partition, crate, rod, channel;
    SctApi::Utility::getpcrc(mid, partition, crate, rod, channel);

    APICALL(&api, modifyBOCParam(&st, partition, crate, rod, channel, ST_RX_DELAY0, (int)floor(t.getOptimum(0)+0.5)), "RxDelayConfigUpdater failed to set delay")
    APICALL(&api, modifyBOCParam(&st, partition, crate, rod, channel, ST_RX_DELAY1, (int)floor(t.getOptimum(1)+0.5)), "RxDelayConfigUpdater failed to set delay")
}
    
}
