#ifndef SCTCALIBRATIONCONTROLLER_CONFIGUPDATERMANAGER_H
#define SCTCALIBRATIONCONTROLLER_CONFIGUPDATERMANAGER_H

#include <string>
#include <map>
#include <boost/shared_ptr.hpp>

using std::map;
using std::string;
using boost::shared_ptr;


namespace SctData {
class TestResult;
}

class Sct_SctApi_T_SctApi;

namespace SctCalibrationController {
    
class ConfigUpdater;
    
/**
  This singleton holds a map between Test names and ConfigUpdaters
  It also has a convenience method that looks up the ConfigUpdater
  and calls its update method.
  @author Matthew Palmer
  */
class ConfigUpdaterManager {
public:
    /**
      Get the instance of the ConfigUpdaterManager
      @note nothrow
      */
    static ConfigUpdaterManager& instance();
    
    /**
      Convenience method calls getUpdater then update on the returned
      ConfigUpdater.
      @throws InvalidArgumentError if a ConfigUpdater can't be found
      @throws SctApiAccessException if there is some problem with the api
      */
    void update(const SctData::TestResult& t, Sct_SctApi_T_SctApi& api) const;
    
    /**
      Get the ConfigUpdater for a given TestResult
      @throws InvalidArgumentError if a ConfigUpdater can't be found
      */
    ConfigUpdater& getUpdater(const string& className) const;
    
    /**
      Sets the ConfigUpdater for a Test name.
      If there is already a ConfigUpdater for the given name, then the map is not updated
      @note nothrow
      @param testName the classname of the TestResult that can be updated by updater
      @return true if updater was successfully added, false otherwise
      */
    bool setUpdater(const string& testName, shared_ptr<ConfigUpdater> updater);
    
private:
    ConfigUpdaterManager();	                                         ///< Only we can make them - this is a singleton
        
    typedef map<string, shared_ptr<ConfigUpdater> > ConfigUpdaterMap;    ///< Map between strings and ConfigUpdaters
    ConfigUpdaterMap updaterMap;					 ///< And our instance of it
};
}

#endif //SCTCALIBRATIONCONTROLLER_CONFIGUPDATERMANAGER_H
