#include "ConfigUpdater.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/ILUMarshalling.h"
#include "SctData/TestResult.h"
#include "SctData/DefectList.h"
#include "SctData/ModuleConfiguration.h"
#include "SctData/ModuleElement.h"

using namespace SctData;
using namespace Sct;

namespace SctCalibrationController {

unsigned long ConfigUpdater::getMID(const TestResult& t, Sct_SctApi_T_SctApi& api) const {
    unsigned long mid = 0;
    ///@todo remove the nasty const_cast below when proper CORBA implementation arrives.
    APIRETCALL(&api, mid, findModuleSerial(&st, const_cast<char*> ( t.getModuleName().c_str())), "ConfigUpdater failed to get MID")
    return mid;
}

void ConfigUpdater::maskChannels(const TestResult& t, DefectSeverity s, Sct_SctApi_T_SctApi& api) const {
    const DefectList::DefectCollection& defects = t.getDefects().getAllDefects();

    ModuleConfiguration config;
    for (unsigned int i=0; i<nChipModule; ++i) {
	config.getChipConfiguration(i).resetMask();
    }

    for (DefectList::DefectCollection::const_iterator i=defects.begin(); i!=defects.end(); ++i) {
	if (i->getPrototype().getSeverity() >= s)
	    maskChannels(config, i->getModuleElement());
    }

    unsigned int maskArray[nChipModule*4];
    for (unsigned int chip=0; chip<nChipModule; ++chip) {
	for (unsigned int i=0; i<4; ++i)
	    maskArray[chip*4 + i] = config.getABCDModule().chip[chip].basic.mask[i];
    }

    APICALL(&api, modifyABCDMask(&st, getMID(t, api), copyArrayToILU<_Sct_SctApi_T_DataBlock_sequence, UINT32>(maskArray, nChipModule*4)), "ConfigUpdater could not update masks")
}

void ConfigUpdater::maskChannels(ModuleConfiguration& config, ModuleElement element) const {
    for (unsigned int i=element.getFirst(); i<=element.getLast(); ++i) {
	config.getChipConfiguration(i/nChannelChip).mask(i%nChannelChip);
    }
}

}
