//#include "Sct/isstream_bugfix.h"
#include "IS_Streamer_Test.h"
#include "Sct/IOManagerDummy.h"
#include "Sct/ISStreamerWrapper.h"
#include <boost/test/unit_test.hpp>
#include "../src/IS/TestData.h"

using boost::unit_test_framework::test_suite;
using namespace Sct;
using namespace std;


void Sct::ISSerializableWrapper<TestData>::constructUniqueID() const {
  std::ostringstream uniqueid;
  uniqueid << getWrappedObject()->runNumber << "."
    	   << getWrappedObject()->startScanNumber << "."
     	   << getWrappedObject()->testName;
  m_uniqueID=uniqueid.str();
}

namespace SctCalibrationController{

  void checkStreaming(Streamable& s){
    IOManagerDummy::instance();
    string a=IOManagerDummy::instance().testStreaming1(s);
    string b=IOManagerDummy::instance().testStreaming1(s);
    BOOST_CHECK_EQUAL(a,b);
  }

  void test_TestDataStreamer(){
    shared_ptr<TestData> td (new TestData);
    td->testName="blah";
    td->runNumber=100;
    td->startScanNumber=199;
    
    td->nScans=3;
    
    td->testVariable=999;
    td->startTime="stared now";
    td->endTime="ended now";

    td->modules_size=2;
    td->modules = new string[td->modules_size];
    td->modules[0]="first test module";
    td->modules[1]="second test module";

    td->testPoints_size=3;
    td->testPoints = new double[td->testPoints_size];
    td->testPoints[0]=0.1;
    td->testPoints[1]=0.2;
    td->testPoints[2]=0.3;

    
    // test default constructor.
    ISSerializableWrapper<TestData> test_ser;

    ISSerializableWrapper<TestData> ser(td);

    cout << " name = " << ser.getClassName() << endl;
    cout << " id = " << ser.getUniqueID() << endl;

    checkStreaming(ser);
  }
  
  IS_Streamer_Test::IS_Streamer_Test() {
    IOManager::addToMap("TestData" , std::auto_ptr<Sct::Streamer>(new ISStreamerWrapper<TestData>() ) ) ;
    add(BOOST_TEST_CASE(&test_TestDataStreamer));
  }
}


