#ifndef SCTARCHIVING_MYSQLEXCEPTION_H
#define SCTARCHIVING_MYSQLEXCEPTION_H
#include <mysql.h>
using namespace std;

namespace SctArchiving{
/**
 * Thrown when an error occurs in <A HREF="http://www.mysql.com/">mysql</A>.
 * @ingroup Exceptions
 * @author Alan Barr
 */
  class MySqlException : public Sct::Exception{
 public:
    /**
      Creates an Exception with a cause.
    */
    MySqlException(const string& msg, const string& file, int line) throw() {
      initialize("MYSQL_ERROR", "SctArchiving::MySqlException", msg, 0, file, line);
    }
    /**
       Creates an Exception without a cause;
    */
    MySqlException(const string& msg, Throwable* cause, 
		  const string& file, int line) throw() {
      initialize("MYSQL_ERROR", "Sct::MySqlException", msg, cause, file, line);
    }
  protected:
    MySqlException() throw() {} 
};
}

#endif //SCTARCHIVING_MYSQLEXCEPTION_H
