#include "SerializableWrappers.h"
#include "Sct/ISSerializableWrapper.h"
#include "Sct/IOManager.h"

#include <sstream>

namespace SctArchiving{

void Sct::ISSerializableWrapper<TestData>::constructUniqueID() const{
  std::ostringstream uniqueid;
  uniqueid << getWrappedObject()->runNumber << "."
	   << getWrappedObject()->startScanNumber << "."
	   << getWrappedObject()->testName;
  m_uniqueID=uniqueid.str();
}

void Sct::ISSerializableWrapper<SequenceData>::constructUniqueID() const{
  std::ostringstream uniqueid;
  uniqueid << getWrappedObject()->runNumber << "."
	   << getWrappedObject()->startScanNumber << "."
	   << getWrappedObject()->sequenceName;
  m_uniqueID=uniqueid.str();
}

#ifdef IS_SERIALIZABLE_BUG
#warning Here is a bug fix for online versions before 00-21-02
  void SequenceDataStreamer::read(Sct::IStream& in, Sct::Streamable& ob, const Sct::IOManager& manager) const{
    Sct::ISSerializableWrapper<SequenceData>& wrapper = dynamic_cast <Sct::ISSerializableWrapper<SequenceData>& > ( ob );
    SequenceData& seq = *wrapper.getWrappedObject();
    in >> seq.sequenceName >> seq.runNumber >> seq.startScanNumber >> seq.nTests;
    if ( seq.testNames_size != 0 ) delete[] seq.testNames;
    in.get( &seq.testNames, seq.testNames_size );
    in >> (int&)seq.status >> seq.startTime >> seq.endTime;
    if ( seq.modules_size != 0 ) delete[] seq.modules;
    in.get( &seq.modules, seq.modules_size );
    in >> seq.version;
    wrapper.constructUniqueID();
  }
 
  void TestDataStreamer::read(Sct::IStream& in, Sct::Streamable& ob, const Sct::IOManager& manager) const{
    Sct::ISSerializableWrapper<TestData>& wrapper = dynamic_cast <Sct::ISSerializableWrapper<TestData>& > ( ob );
    TestData& td = *wrapper.getWrappedObject();
    in >> td.testName >> td.runNumber >> td.nScans >> td.startScanNumber >> td.testVariable;
    if ( td.testPoints_size != 0 ) delete[] td.testPoints;
    in.get( &td.testPoints, td.testPoints_size );
    in >> (int&)td.status >> td.startTime >> td.endTime;
    if ( td.modules_size != 0 ) delete[] td.modules;
    in.get( &td.modules, td.modules_size );
    in >> td.version;
    wrapper.constructUniqueID();
  }

  static bool dummy1 = Sct::IOManager::addToMap("SequenceData" , std::auto_ptr<Sct::Streamer>(new SequenceDataStreamer() ) ) ;
  
  static bool dummy2 = Sct::IOManager::addToMap("TestData", std::auto_ptr<Sct::Streamer>(new TestDataStreamer() ) ) ;
#else

  // If is bug in istream is fixed (after online00-21-02)
  static bool dummy1 = Sct::IOManager::addToMap("SequenceData" , std::auto_ptr<Sct::Streamer>(new Sct::ISStreamerWrapper<SequenceData>() ) ) ;
  static bool dummy2 = Sct::IOManager::addToMap("TestData", std::auto_ptr<Sct::Streamer>(new Sct::ISStreamerWrapper<TestData>() ) ) ;
  
#endif

}
