#ifndef SCTARCHIVING_PUTCOMMAND_H
#define  SCTARCHIVING_PUTCOMMAND_H
#include "Sct/Serializable.h"
#include "ArchivingCommand.h"
#include "Sct/IOManager.h"

namespace SctArchiving{
  /**
     Command which puts an object somewhere! The object
     must be set either in the constructr or with the set() method, 
     before the execute() method is called.
  */
  class PutCommand : public ArchivingCommand {
  public:
    /** constructor with name of object to put */
    PutCommand(boost::shared_ptr<Sct::Serializable> ob);
    /** allows you to set the IOParams */
    void setParams(boost::shared_ptr<Sct::IOParams> params);
    /** get the IOParams */
    boost::shared_ptr<Sct::IOParams> getParams();
    /** constructor without name - need to use set before execute */
    PutCommand() {}
    /** destructor */
    ~PutCommand() {}
    /** use to set object before execute*/
    void set(boost::shared_ptr<Sct::Serializable> ob);
  protected:
    boost::shared_ptr<Sct::Serializable> m_ob;
    boost::shared_ptr<Sct::IOParams> m_params;
  };
  
  inline void PutCommand::set(boost::shared_ptr<Sct::Serializable> ob){
    m_ob = ob;
  }

  inline PutCommand::PutCommand(boost::shared_ptr<Sct::Serializable> ob)
    : m_ob(ob)
    {}

  inline boost::shared_ptr<Sct::IOParams> PutCommand::getParams(){
    return m_params;
  }
  
  inline void  PutCommand::setParams(boost::shared_ptr<Sct::IOParams> p){
    m_params=p;
  }
}

#endif
