#ifndef SCTARCHIVING_ISGETCOMMAND_H
#define  SCTARCHIVING_ISGETCOMMAND_H
#include "GetCommand.h"
#include "Sct/Serializable.h"
#include "Sct/IS/IONameIS.h"

namespace SctArchiving{
  /** command to get an object from the archive */
  class IsGetCommand : public GetCommand {
  public:
    /** Gets IOName from archive */
    IsGetCommand(boost::shared_ptr<Sct::IS::IONameIS> name);
    /** gets the object from the archive */
    virtual void execute();
    /** destructor */
    ~IsGetCommand();
    /** virtual constructor */
    virtual boost::shared_ptr<ArchivingCommand> create() const;
  private:
    IsGetCommand();
    /// read a IS control object
    shared_ptr<Sct::Serializable> retrieveISOB(const std::string& name) const;
  };
}
#endif
