#include "IsGetCommand.h"
#include "Archiver.h"
#include "SerializableWrappers.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/IoExceptions.h"

#include "is/isinfoany.h"
#include <boost/timer.hpp>

namespace SctArchiving{
  IsGetCommand::IsGetCommand(boost::shared_ptr<Sct::IS::IONameIS> name)
    : GetCommand(name)
  {}

  IsGetCommand::IsGetCommand() {}

  IsGetCommand::~IsGetCommand(){}

  void IsGetCommand::execute(){
    boost::timer t;
    if (m_name->getIOName().find("SctData")==std::string::npos) {
      // IS object
      m_ob = retrieveISOB( m_name->getIOName() );
    }else{
      // Serializable
      m_ob = Sct::IS::IOManagerIS::instance().read(m_name->getIOName());
    }
    
    Archiver::instance().addISTime(t.elapsed());
  }

  boost::shared_ptr<ArchivingCommand> IsGetCommand::create()const{
    boost::shared_ptr<ArchivingCommand> cmd(new IsGetCommand() );
    return cmd;
  }  
  
  ///@todo There is a much cleaner way of doing this with a map!
  shared_ptr<Sct::Serializable> IsGetCommand::retrieveISOB(const std::string& name) const {
    ISInfoAny infoany;
    ISInfo::Status result = SctNames::getISDictionary().findValue(name.c_str(), infoany);
    if (result != ISInfo::Success) {
      std::ostringstream oss;
      oss << "Error reading from IS server.  Couldn't get: "
	  << name << " expected class TestData";
      throw Sct::IsException(result, oss.str(), __FILE__, __LINE__);
    }
    const std::string& classname=infoany.type().name();

    if (classname == "TestData") {
      shared_ptr<TestData> td ( new TestData() );
      ISInfo::Status result = SctNames::getISDictionary().findValue(name.c_str(), *td);
      if (result != ISInfo::Success) {
	std::ostringstream oss;
	oss << "Error reading from IS server.  Couldn't get: "
	    << name << " expected class TestData";
            throw IsException(result, oss.str(), __FILE__, __LINE__);
      }
      return shared_ptr<Sct::Serializable> ( new Sct::ISSerializableWrapper<TestData>(td) );
    } else if (classname == "SequenceData"){
      shared_ptr<SequenceData> td ( new SequenceData() );
      ISInfo::Status result = SctNames::getISDictionary().findValue(name.c_str(), *td);
      if (result != ISInfo::Success) {
	std::ostringstream oss;
	oss << "Error reading from IS server.  Couldn't get: "
	    << name << " expected class SequenceData";
            throw Sct::IsException(result, oss.str(), __FILE__, __LINE__);
      }
      return shared_ptr<Sct::Serializable> ( new Sct::ISSerializableWrapper<SequenceData>(td) );   
    } else {
      throw Sct::InvalidArgumentError(string("I don't know how to retrieve ") + name, __FILE__, __LINE__);
    }
  }

}
