#ifndef SCTARCHIVING_ARCHIVINGCOMMAND_H
#define  SCTARCHIVING_ARCHIVINGCOMMAND_H
#include <list>
#include <boost/shared_ptr.hpp>
#include <iostream>

namespace SctArchiving{
/** 
    Interface for a command. These commands are created by the
    Archiver, and passed to the ArchivingWorkerGroup, which calls the 
    execute() method. 
    Uses the `composite' and  `command' patterns!
*/
class ArchivingCommand {
 public:
  /** virtual destructor makes all sub-class destructors virtual */
  virtual ~ArchivingCommand(){}
  /** execute this command. Default implimentation just does all sub-commands, sending any errors to MRS as it goes */
  virtual void execute()=0;
  /** creates derrived class using virtual constructor idiom */
  virtual boost::shared_ptr<ArchivingCommand> create() const=0;
 protected:
  ArchivingCommand() {}
};
 
}// end of namespace


#endif //#ifndef SCTARCHIVING_ARCHIVINGCOMMAND_H
