#include "ArchivePutCommand.h"
#include "Archiver.h"
#include "Sct/Archive/IOManagerArchive.h"
#include "boost/timer.hpp"

namespace SctArchiving{
  ArchivePutCommand::ArchivePutCommand(boost::shared_ptr<Sct::Serializable> ob)
    : PutCommand(ob)
  {}

  ArchivePutCommand::~ArchivePutCommand(){}

  ArchivePutCommand::ArchivePutCommand() {
  }

  void ArchivePutCommand::execute(){
    boost::timer t;
    if (!m_ob.get()) throw Sct::IllegalStateError("Null pointer", __FILE__, __LINE__);
    Archiver::instance().getIOManagerArchive().write(*m_ob, m_params.get());
    Archiver::instance().addFileTime(t.elapsed());
    Archiver::instance().incrimentNArchived();
  }

  shared_ptr<ArchivingCommand> ArchivePutCommand::create() const{
    return shared_ptr<ArchivingCommand> (new ArchivePutCommand() );
  }
}
