#include "ArchiveGetCommand.h"
#include "boost/timer.hpp"
#include "Archiver.h"
#include "Sct/Archive/IOManagerArchive.h"

namespace SctArchiving{
  ArchiveGetCommand::ArchiveGetCommand(boost::shared_ptr<Sct::Archive::IONameArchiveFile> name)
    : GetCommand(name)
  {}

  ArchiveGetCommand::ArchiveGetCommand() {}
  
  ArchiveGetCommand::~ArchiveGetCommand(){}

  void ArchiveGetCommand::execute(){
    boost::timer t;
    m_ob=Archiver::instance().getIOManagerArchive().read(m_name->getIOName());
    Archiver::instance().addFileTime(t.elapsed());
    Archiver::instance().incrimentNRetrieved();
  }

  boost::shared_ptr<ArchivingCommand> ArchiveGetCommand::create() const{
    return shared_ptr<ArchivingCommand>(new ArchiveGetCommand());
  }
}
