//#include "Sct/isstream_bugfix.h"
#include "Streamer_Test.h"
#include "Sct/Archive/IOManagerArchiveFile.h"
#include "Sct/IStreamAdaptor.h"
#include "Sct/ISIStreamWrapper.h"
#include "../src/SerializableWrappers.h"

#include <sstream>

using namespace boost;
using boost::unit_test_framework::test_suite;
using namespace std;
using namespace Sct;
using namespace Sct::Archive;

namespace SctArchiving{

  void test_wrapper1(){
    cout << "start of test_wrapper1" << endl;
    string s;
    istringstream iss(s);
    IStreamAdaptor ad(iss);
    new ISIStreamWrapper(ad);
    cout << "end of test_wrapper1" << endl;
  }

  void test_TestData(){
    shared_ptr<Serializable> ob = IOManagerArchiveFile::instance().read("./TestData.1008.0.StrobeDelayTest.gz");
    shared_ptr<ISSerializableWrapperI> isi = 
      dynamic_pointer_cast<ISSerializableWrapperI>(ob);
    BOOST_CHECK(isi.get() != 0);
    std::cout << "classname=" << isi->getClassName()
	      << ", id = " << isi->getUniqueID() << std::endl;
    //isi->publishWrappedObjectToServer("EventData");
  };
  

  Streamer_Test::Streamer_Test(){
    add(BOOST_TEST_CASE(&test_wrapper1));
    //#warning replace this test when isstream.h is updated in online 00-21-02
    add(BOOST_TEST_CASE(&test_TestData));
  }
}
