#include "../src/AnalysisServiceI.hh"
#include <ipc/object.h>
#include "Sct/SctNames.h"
#include "Sct/Exception.h"
#include <string>

int main(int argc, char**argv){
    Sct::setExceptionHandlers(argv[0]);
    using namespace std;
    using Sct::SctNames;  
    
    cout << "AnalysisService test:"<<endl;
    AnalysisServiceIStatus status;
    
    cout <<"... looking in partition ..."<<SctNames::getPartitionName()<<ends;
    IPCPartition& p = SctNames::getPartition();
    
    cout <<" ... getting a handle ..."<<ends;
    IPCObjectVar<AnalysisServiceI_T_AnalysisServiceInterface> handle = 
	p.lookup(AnalysisServiceI_C_AnalysisServiceInterface_serverName, AnalysisServiceI_C_AnalysisServiceInterface_instanceName, AnalysisServiceI_T_AnalysisServiceInterface::ILUClassRecord);
    
    if (handle==0){ cerr<<"Error: handle==0"<<endl; return -1;}
    
    cout <<"Got Handle..."<<endl;
    
    status.returnCode=0;

    if (argc==1){
	cout << handle->status(&status); 
    }

    if (argc==2){
	handle->analyze(&status, argv[1]);
    }
    if (argc==3){
	handle->analyzeModule(&status, argv[1], argv[2]);
    }
    return 0;
}
