#include "../src/AnalysisServiceI.hh"
#include <ipc/object.h>
#include "Sct/SctNames.h"
#include "Sct/Exception.h"
#include <string>

int main(int argc, char**argv){
    Sct::setExceptionHandlers(argv[0]);
    using namespace std;
    using Sct::SctNames;  
    
    cout << "AnalysisService purge:"<<endl;
    AnalysisServiceIStatus status;
    
    cout <<"... looking in partition ..."<<SctNames::getPartitionName()<<ends;
    IPCPartition& p = SctNames::getPartition();
    
    cout <<" ... getting a handle ..."<<ends;
    IPCObjectVar<AnalysisServiceI_T_AnalysisServiceInterface> handle = 
	p.lookup(AnalysisServiceI_C_AnalysisServiceInterface_serverName, AnalysisServiceI_C_AnalysisServiceInterface_instanceName, AnalysisServiceI_T_AnalysisServiceInterface::ILUClassRecord);
    
    if (handle==0){ cerr<<"Error: handle==0"<<endl; return -1;}
    
    cout <<"Got Handle..."<<endl;
    
    handle->purge(&status);

    cout << " returning " << endl;
    return 0;
}
