#ifndef TRIMRANGEALGORITHM_H
#define TRIMRANGEALGORITHM_H
#include "AnalysisAlgorithm.h"
#include "SctData/TrimRangeTestResult.h"
#include <vector>

using std::vector;

namespace SctAnalysis{
    /**
       Algorithm considers many trim range scans, possibly over many different ranges, 
       makes fits to graphs, and works out the best trim range to use.
       <BR>Input: TrimRangeTest
       <RR>Output: TrimRangeTestResult
     */
    class TrimRangeAlgorithm : public AnalysisAlgorithm{
    public:
    class TrimRange;
    class TrimPoint;
    	virtual bool canAnalyze() const;
	virtual void analyze();
	virtual void loadData();
	virtual shared_ptr<SctData::TestResult> createTestResult() const;
	/**
	   destructor
	 */
	virtual ~TrimRangeAlgorithm() throw() {;}
	/**
	   constructor
	*/
	TrimRangeAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {;}
	/**
	 * over-ride
	 */
	virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();

	/** Fit the graph of data points with a linear fit.*/
	static void doTrimDataFit(SctData::TrimRangeTestResult::ChipTrimData& chipData) throw();
	//@{
	//@name Target setting
	/** Number of trim targets to consider */
	static unsigned nTargets() throw() {return 120;}
	/** First trim target to consider */
	static float firstTarget() throw() {return 2.5;}
	/** Step between trim targets to consider */
	static float targetStep() throw() {return 2.5;}
	//@}
	/** find which trim ranges and points are represented in the data */
	vector<TrimRange> createRanges(const SctData::TestResult& r) throw();
	
	/** allow trim range variation between chips? */
	bool allowTrimRangeVariation() const throw() {return s_rangeVariation;}
	/** allow trim target variation between chips? */
	bool allowTrimTargetVariation() const throw() {return s_targetVariation;}
	
	// holds data about points in a trim range. 
	class TrimPoint{
	public:
	    /**
	       constructor @param value the trim range register value 
	       @param scan the index of the scan in the test
	    */
	    TrimPoint(int value, int scan) throw() : value(value), scan(scan) {;}
	    TrimPoint() throw() : value(-2), scan(-2) {;}
	    int value; ///< The trim value
	    int scan;  ///< The index of the scan in the test.
	};
	
	/** holds data about a trim range */
	class TrimRange{
	public:
	    TrimRange() throw() : range(-2) {;}
	    /// constructor @param range the value of the trim range register
	    TrimRange(int range) throw() : range (range) {;}
	    int range;  ///< 
	    vector< TrimPoint > points;
	    /** check if "this" has smaller value of "range" than other */
	    bool operator<(const TrimRange& r) const throw() { return (range<r.range);}
	};
    private:
	TrimRangeAlgorithm() {}
	static shared_ptr<const SctData::TrimRangeTestResult::ChipTrim> 
	getChipTrim(const SctData::TrimRangeTestResult::ChipTrimData& data, 
		    const float target,
		    short unsigned irange) throw();
	static bool inMap;                      ///<static var to force addition to map
	
	static bool s_targetVariation;
	static bool s_rangeVariation;
    };

} // end of namespace SctAnalysis
#endif // #ifndef TRIMRANGEALGORITHM_H
