#ifndef STROBEDELAYALGORITHM_H
#define STROBEDELAYALGORITHM_H
#include "AnalysisAlgorithm.h"

namespace SctData {
    class StrobeDelayTestResult;
    class FitScanResult;
}

namespace SctAnalysis {
    /**
       Algorithm for single-scan Strobe-Delay Test.
       Uses a single FitScanResult to find the optimum value of the strobe delay.
    */
class StrobeDelayAlgorithm : public AnalysisAlgorithm {
public:        
    /** 
	finds the optimum - a fractions of the way from the mid-rise to the mid-fall of the 
	function.
     */
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();    
    /** 
	constructor 
     */
    StrobeDelayAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~StrobeDelayAlgorithm() throw() {}
private:
    StrobeDelayAlgorithm() {}
    static bool inMap;    
};
}
#endif //#ifndef STROBEDELAYALGORITHM_H
