#ifndef NPTGAINALGORITHM_H
#define NPTGAINALGORITHM_H

#include "AnalysisAlgorithm.h"
#include "Sct/Exception.h"
#include "Sct/SctParameters.h"
#include <boost/scoped_ptr.hpp>
#include "SctData/ModuleElement.h"
#include <memory>

namespace SctData {
class NPtGainTestResult;
class NPtGainTestResultData;
class TestResult;
class FitScanResult;
class FitObject;
class DefectList;
class ResponseCurve;
}

using std::auto_ptr;
using boost::scoped_ptr;
using SctData::NPtGainTestResult;
using SctData::NPtGainTestResultData;
using SctData::FitScanResult;
using SctData::FitObject;
using SctData::ModuleElement;
using SctData::DefectList;
using SctData::ResponseCurve;
using namespace Sct;

namespace SctAnalysis {
    
/**
  Encodes how to do a response curve fit thing.
  */
class NPtGainAlgorithm : public AnalysisAlgorithm {
public:
    /**
       Constructor
     */
    NPtGainAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /**
       Destructor
    */
    virtual ~NPtGainAlgorithm() throw() {}
    /**
       Source of response curves of type given by setResponseCurve
       @params nPts The number of points in the response curve (default such that large
       number of points response curve is returned)
    */
    static boost::shared_ptr<ResponseCurve> getResponseCurve(unsigned int nPts=4) throw(LogicError);
    /**
       Method of setting response curve type. @param smart pointer to prototype response curve 
       @note parameter is sunk.
       @note Always uses linear response curve if number of points is <= 3
    */
    static void setResponseCurve( auto_ptr<ResponseCurve> rc) throw();

    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();
private:
    NPtGainAlgorithm() {}
    
    /// prototype used in virtual constuctor idiom to make rc's.
    static boost::shared_ptr<ResponseCurve> s_responseCurve;
    static bool inMap;		//static var to force addition to map
    typedef FitObject& (FitScanResult::*getFitFunction) (unsigned int) const;
    /// does what it says on the tin
    void setupGraph(unsigned int id, const ModuleElement& element, getFitFunction fitFunc, NPtGainTestResult& test, NPtGainTestResultData& testData, bool trimPoints = false) throw(LogicError);
    
    ///Does a fit given a way of getting the data.
    void doFit(unsigned int id, getFitFunction fitFunc, NPtGainTestResult& test, NPtGainTestResultData& testData) throw(LogicError) ;
    
    /**
      Merges defects from the FitScanResults that effect element up to and including scan: lastPoint
      */
    void mergeDefects(NPtGainTestResult& test, const ModuleElement& element, unsigned int lastPoint);
    
    /**
    Once the fits are done, we need to figure out any defects. These are worked out by conparison
    with some other data.
    */
    static void doDefect(const ModuleElement& e, DefectList& defects, 
			 const NPtGainTestResultData& data,
			 const NPtGainTestResultData& comparisonData) throw(LogicError);
    
    unsigned int nOnePointTrimmed;
    unsigned int nTwoPointTrimmed;
};
    
}

#endif //#ifndef NPTGAINALGORITHM_H
