#ifndef ANALYSISALGORITHMMAP_H
#define ANALYSISALGORITHMMAP_H

#include <string>
#include <map>
#include <boost/utility.hpp>
#include <boost/shared_ptr.hpp>
#include "Sct/LogicErrors.h"

using std::string;
using std::map;
using std::auto_ptr;
using boost::shared_ptr;

class TestData;

namespace SctAnalysis {
    
class AnalysisAlgorithm;
    
/**
  AnalysisAlgorithmMap maps Tests to AnalysisAlgorithms.
  It is currently done using the Test name.
  @author Matthew Palmer
  @date 11 June 2003
  */
class AnalysisAlgorithmMap : boost::noncopyable {
public:    
    /**
      Get the singleton instance.
      */
    static AnalysisAlgorithmMap& instance();
    
    /**
      @param test The name of the test to analyze
      @return An AnalysisAlgorithm of the type registered for test
      @throw InvalidArgument if test is not in the map
      */
    shared_ptr<AnalysisAlgorithm> getAlgorithm(const TestData& testData, const string& moduleName) const throw(Sct::InvalidArgument);
    
    /**
      Sets the algorithm for a given Test name.
      May only be called prior to multi-threading!  I.e. at static initialization time.
      @param testName the name of the Test
      @param alg the AnalysisAlgorithm that can analyze them
      @return true if successful
      */
    bool setAlgorithm(const string testName, auto_ptr<AnalysisAlgorithm> alg) throw();
    
    /**
      Gets a status string for a given type of test
      @note Nothrow
      */
    string getStatus(string testName);
    
    /**
      Gets the status for all test types
      @note Nothrow
      */
    string getAllStatus();
      
    
private:
    //Private constructor
    AnalysisAlgorithmMap() {}
    /// The map
    map<string, shared_ptr<AnalysisAlgorithm> > algMap;
};

}

#endif //#ifndef ANALYSISALGORITHMMAP_H
