// tinyutils2.cc
//  provides functions for double vectors allocation and clean-up

#include <iostream>
using namespace std;

#include "tinyutils2.h"

// allocates memory for an array of doubles.
// returns zero if failure.
// example usage:  allocate( b, 1 , N ) ; 
int allocate ( Dvector &a , int low, int high ) {
  a.low = low ; a.high = high ; 
  int N = high-low+1 ;
  if ( N <= 0 ) {
    cerr << "Illegal range in dvector: "
	 << low << ", " << high << endl ;
    return 0 ;
  }
  a.v = new double[N] ; // allocates memory for a[0]..a[N-1]
  if(!a.v) {
    cerr << "Memory allocation failed\n" ;
    return 0 ; 
  } else {
    a.v -= low ; // offset the pointer by low.
    return 1 ; 
  }
}

void freeDvector ( Dvector &b ) {
  delete [] &(b.v[b.low]) ; 
  b.high = b.low - 1 ; 
}

// Note that default parameter values (such as 'style=0')
// have already been specified in the function declaration
// in tinyutils2.h.
void printDvector( Dvector &b , int style ) {
  // style 1 means "all on one line"
  // style 0 means "in one column"
  for ( int n = b.low ; n <= b.high ; n ++ ) {
    cout << b.v[n] ;
    if(style) {
      if ( n == b.high ) 
	cout << endl;
      else
	cout << "\t" ;
    } else {
      cout << endl;
    }
  }
}

double square( double x ) {
  return x*x ;
}

