// tinyutils.cc
//  provides functions for double vectors allocation and clean-up

#include <iostream>
using namespace std;

#include "tinyutils.h"

// allocates memory for an array of doubles, say
//          b[low]..b[high]
// returns zero if failure.
// example usage:  b = dvector( 1 , N ) ; 
double *dvector ( int low, int high ) {
  int N = high-low+1 ;
  double *a ; 
  if ( N <= 0 ) {
    cerr << "Illegal range in dvector: "
	 << low << ", " << high << endl ;
    return 0 ;
  }
  a = new double[N] ; // allocates memory for a[0]..a[N-1]
  if(!a) {
    cerr << "Memory allocation failed\n" ;
    return 0 ; 
  }
  return (a-low) ; // offset the pointer by low.
  //                  the user uses b[low]..b[high]
}

void freedvector ( double *b , int low ) {
  delete [] &(b[low]) ; // The '[]' indicate that what's
} //                       being freed is an array

// Note that default parameter values (such as 'style=0')
// have already been specified in the function declaration
// in tinyutils.h.
void printVector( double * b , int lo , int hi , int style ) {
  // style 1 means "all on one line"
  // style 0 means "in one column"
  for ( int n = lo ; n <= hi ; n ++ ) {
    //    cout << "b[" << n << "] = " ;
    cout << b[n] ;
    if(style) {
      if ( n == hi ) 
	cout << endl;
      else
	cout << "\t" ;
    } else {
      cout << endl;
    }
  }
}

double square( double x ) {
  return x*x ;
}

