// package2.cc
//   demonstrates how to use structures and functions
//   defined in a separately-compiled file (tinyutils2.cc).
//   The structure Dvector is defined in tinyutils2.h

#include <iostream>
using namespace std;

// Both this file and tinyutils2.cc include the
// function declarations from a single header file: 
#include "tinyutils2.h"

int main()
{
  Dvector a , b ; 
  int    N = 20 ;

  // allocate the space for b.v[1]..b.v[N]
  allocate( b , 1 , N ) ; 
  allocate( a , 1 , N ) ; 

  for ( int n = 1 ; n <= N ; n ++ ) 
    a.v[n] = static_cast<double>(n) ;
  for ( int m = 1 ; m <= N ; m ++ ) 
    b.v[m] = square( a.v[m] ) ; 
  printDvector( b ) ; 

  // free the memory
  freeDvector( b ) ;
  freeDvector( a ) ;
  return 0;
}

