// package1.cc
//   demonstrates how to use functions
//   defined in a separately-compiled file (tinyutils.cc)

#include <iostream>
using namespace std;

// Both this file and tinyutils.cc include the
// function declarations from a single header file: 
#include "tinyutils.h"

// In this example, we use functions 'dvector',
// 'square', 'printVector', and 'freedvector', all defined in
// tinyutils.cc

int main()
{
  double *b , *a ; 
  int    N = 20 ;

  // allocate the space for b[1]..b[N]
  b = dvector( 1 , N ) ; 
  a = dvector( 1 , N ) ; 

  for ( int n = 1 ; n <= N ; n ++ ) 
    a[n] = static_cast<double>(n) ;
  for ( int m = 1 ; m <= N ; m ++ ) 
    b[m] = square( a[m] ) ; 
  printVector( b , 1 , N ) ; 

  // free the memory
  freedvector( b , 1 ) ;
  freedvector( a , 1 ) ;
  return 0;
}

