// Libraries
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ENTER 13 // byte value of the Enter key (LF)
#define MCHARS 8 // max chars to accept 


const char dataRequestString[4] = "idr";// Interlock Unit Data Request
const char enableRequestString[4] = "ena";// Enable request
const char* lookup_table[] = {
  "tl","th", "ne", "rn", "tn", "bn", "rl", "rh"};
enum{
  Tlow, Thigh, Nenable, Rnom, Tnom, Bntc, RHlow, RHhigh, None };

char cmdbuf[4], intbuf[5], inStr[MCHARS];
byte nBytes = 0;
int inSerial = 0;

void setup(){
  // set up Serial communication (through USB)
  Serial.begin(28800);
  Serial.flush();// clear receive buffer
  Serial.print(">");
  memset(cmdbuf, '\0', 4);
  memset(intbuf, '\0', 5);
  memset(inStr, '\0', MCHARS);
}

void loop(){
  while(Serial.available() && inSerial != ENTER){
    inSerial = Serial.read();
    Serial.print((char)inSerial);
    inStr[nBytes] = (char)inSerial;      // add the byte to the "String" array
    if(nBytes < 3) cmdbuf[nBytes] = (char)inSerial;
    else if(nBytes < 7) intbuf[nBytes-3] = (char)inSerial;
    nBytes++;                          // increase the item string count
  }

  if(inSerial == ENTER){
    Serial.flush();                         // flush the serial data (overkill?)
    Serial.println("  ");
    Serial.print(nBytes);
    Serial.print(" B read from serial: ");
    Serial.println(inStr);                     // print a newline
    int convint = atoi(intbuf);
    Serial.println(cmdbuf);
    Serial.print(intbuf);
    Serial.print(", value: ");
    Serial.println(convint);
    inSerial = 0;
    memset(cmdbuf, '\0', 4);
    memset(intbuf, '\0', 5);
    memset(inStr, '\0', MCHARS);
    nBytes = 0;
  }



}// loop

int lookup(char rxcmd[])
{
  const int ncmds = sizeof lookup_table / sizeof *lookup_table;
  for(int i=0; i!= ncmds; i++)
    if( strcmp(rxcmd, lookup_table[i]) == 0) return i;
  return None;
}












