// sketch for pre-loading EEPROM defaults for the ATLAS Upgrade Interlock II

// Bart Hommels
// University of Cambridge

// 28/9/2012


// include libraries
#include <stdio.h>
#include <EEPROM.h>// for using EEPROM
#include "EEPROMAnything.h" // for writing multiple-byte objects to EEPROM

// EEPROM addresses for non volatile parameters
const unsigned int addr_h_NTC_T_Lo = 0;// float: 4B
const unsigned int addr_h_NTC_T_Hi = 4;// float: 4B
const unsigned int addr_h_NTC_N_enable = 8;// byte
const unsigned int addr_h_NTC_nSamples = 12;//byte
const unsigned int addr_h_NTC_Rnom = 16;// byte
const unsigned int addr_h_NTC_Tnom = 20;// byte
const unsigned int addr_h_NTC_B = 24;// u_int: 2B

const unsigned int addr_u_NTC_T_Lo = 40;// float: 4B
const unsigned int addr_u_NTC_T_Hi = 44;// float: 4B
const unsigned int addr_u_NTC_N_enable = 48;// byte
const unsigned int addr_u_NTC_nSamples = 52;//byte
const unsigned int addr_u_NTC_Rnom = 56;// byte
const unsigned int addr_u_NTC_Tnom = 60;// byte
const unsigned int addr_u_NTC_B = 64;// u_int: 2B

const unsigned int addr_Sht_T_Lo = 80;// float: 4B
const unsigned int addr_Sht_T_Hi = 84;// float: 4B
const unsigned int addr_Sht_RH_Lo = 88;// float: 4B
const unsigned int addr_Sht_RH_Hi = 92;// float: 4B
const unsigned int addr_Sht_Enable = 96;// byte

// main program will then blink LED
const int ledPin =  13;      // the number of the LED pin
int ledState = LOW; 
unsigned long previousMillis = 0; 
unsigned long interval = 1000;   

// H0-7 NTC
float h_NTC_T_Lo = 10.0;
float h_NTC_T_Hi = 30.0;
byte h_NTC_N_enable = 8;
byte HnSamples = 2;// 2 should be a good fallback number
// NTC parameters to reconstruct temperature from ADC readings
byte h_NTC_Rnom = 10;// H0-7 NTC resistance at nominal T, in kOhm. Hardware options are 1, 10kOhm
byte h_NTC_Tnom = 25;// H0-7 NTC nominal temperature
unsigned int h_NTC_B = 3435; // H0-7 NTC B factor

// U8-9 NTC defaults (use GL23 for the moment: R(20 deg C) = 2kOhm, B=3125)
float u_NTC_T_Lo = 10.0;
float u_NTC_T_Hi = 30.0;
byte u_NTC_N_enable = 2;
byte UnSamples = 2;
byte u_NTC_Rnom = 10;// U8-9 NTC resistance at nominal T in kOhm: [1,2,3,5,10,20]
byte u_NTC_Tnom = 25;// should be 20 or 25
unsigned int u_NTC_B = 3435;// adjustable 3000-4000 K in 5 K steps

// SHT7x RH/T sensor
float SHT_T_Lo = 10.0;
float SHT_T_Hi = 30.0;
float SHT_RH_Lo = 30.0;
float SHT_RH_Hi = 60.0;
byte sht_enable = 1;

void setup(){
  Serial.begin(28800);
  Serial.println("Pre-programming EEPROM");
        EEPROM_writeAnything(addr_h_NTC_T_Lo, h_NTC_T_Lo);
      EEPROM_writeAnything(addr_h_NTC_T_Hi, h_NTC_T_Hi);
      EEPROM_writeAnything(addr_h_NTC_N_enable, h_NTC_N_enable);
      EEPROM_writeAnything(addr_h_NTC_nSamples, HnSamples);
      EEPROM_writeAnything(addr_h_NTC_Rnom, h_NTC_Rnom);
      EEPROM_writeAnything(addr_h_NTC_Tnom, h_NTC_Tnom);
      EEPROM_writeAnything(addr_h_NTC_B, h_NTC_B);
      // U8-9 NTCs
      EEPROM_writeAnything(addr_u_NTC_T_Lo, u_NTC_T_Lo);
      EEPROM_writeAnything(addr_u_NTC_T_Hi, u_NTC_T_Hi);
      EEPROM_writeAnything(addr_u_NTC_N_enable, u_NTC_N_enable);
      EEPROM_writeAnything(addr_u_NTC_nSamples, UnSamples);
      EEPROM_writeAnything(addr_u_NTC_Rnom, u_NTC_Rnom);
      EEPROM_writeAnything(addr_u_NTC_Tnom, u_NTC_Tnom);
      EEPROM_writeAnything(addr_u_NTC_B, u_NTC_B);
      // SHT 71 RH/T
      EEPROM_writeAnything(addr_Sht_T_Lo, SHT_T_Lo);
      EEPROM_writeAnything(addr_Sht_T_Hi, SHT_T_Hi);
      EEPROM_writeAnything(addr_Sht_RH_Lo, SHT_RH_Lo);
      EEPROM_writeAnything(addr_Sht_RH_Hi, SHT_RH_Hi);
      EEPROM_writeAnything(addr_Sht_Enable, sht_enable);

Serial.println("EEPROM programming done");

pinMode(ledPin, OUTPUT);  

}

void loop(){
 unsigned long currentMillis = millis();
 
  if(currentMillis - previousMillis > interval) {
    previousMillis = currentMillis;   

    if (ledState == LOW)
      ledState = HIGH;
    else
      ledState = LOW;

    digitalWrite(ledPin, ledState);
  }
  
}

