// sketch for pre-loading EEPROM defaults for the ATLAS Upgrade Interlock II

// Bart Hommels
// University of Cambridge

// 28/9/2012


// include libraries
#include <stdio.h>
#include <EEPROM.h>// for using EEPROM
#include "EEPROMAnything.h" // for writing multiple-byte objects to EEPROM

// EEPROM addresses for non volatile parameters
const unsigned int addr_h_NTC_T_Lo = 0;// float: 4B
const unsigned int addr_h_NTC_T_Hi = 4;// float: 4B
const unsigned int addr_h_NTC_N_enable = 8;// byte
const unsigned int addr_h_NTC_Rnom = 9;// byte
const unsigned int addr_h_NTC_Tnom = 10;// byte
const unsigned int addr_h_NTC_B = 11;// u_int: 2B

const unsigned int addr_u_NTC_T_Lo = 20;// float: 4B
const unsigned int addr_u_NTC_T_Hi = 24;// float: 4B
const unsigned int addr_u_NTC_N_enable = 28;// byte
const unsigned int addr_u_NTC_Rnom = 29;// byte
const unsigned int addr_u_NTC_Tnom = 30;// byte
const unsigned int addr_u_NTC_B = 31;// u_int: 2B

const unsigned int addr_Sht_T_Lo = 50;// float: 4B
const unsigned int addr_Sht_T_Hi = 54;// float: 4B
const unsigned int addr_Sht_RH_Lo = 58;// float: 4B
const unsigned int addr_Sht_RH_Hi = 62;// float: 4B
const unsigned int addr_Sht_Enable = 66;// float: 4B

// main program will then blink LED
const int ledPin =  13;      // the number of the LED pin
int ledState = LOW; 
unsigned long previousMillis = 0; 
unsigned long interval = 1000;   

void setup(){
  Serial.begin(28800);
  Serial.println("Pre-programming EEPROM");
    // retrieve variables from EEPROM
  // H0-7 NTCs
  EEPROM_writeAnything(addr_h_NTC_T_Lo, 10.0);
  EEPROM_writeAnything(addr_h_NTC_T_Hi, 40.0);
  EEPROM_writeAnything(addr_h_NTC_N_enable, 1);
  EEPROM_writeAnything(addr_h_NTC_Rnom, 10);
  EEPROM_writeAnything(addr_h_NTC_Tnom, 25);
  EEPROM_writeAnything(addr_h_NTC_B, 3435);
  // U8-9 NTCs
  EEPROM_writeAnything(addr_u_NTC_T_Lo, 10.0);
  EEPROM_writeAnything(addr_u_NTC_T_Hi, 40.0);
  EEPROM_writeAnything(addr_u_NTC_N_enable, 0);
  EEPROM_writeAnything(addr_u_NTC_Rnom, 10);
  EEPROM_writeAnything(addr_u_NTC_Tnom, 25);
  EEPROM_writeAnything(addr_u_NTC_B, 3435);
  // SHT 71 RH/T
  EEPROM_writeAnything(addr_Sht_T_Lo, 10);
  EEPROM_writeAnything(addr_Sht_T_Hi, 40);
  EEPROM_writeAnything(addr_Sht_RH_Lo, 30);
  EEPROM_writeAnything(addr_Sht_RH_Hi, 60);
  EEPROM_writeAnything(addr_Sht_Enable, 0);

Serial.println("EEPROM programming done");

pinMode(ledPin, OUTPUT);  

}

void loop(){
 unsigned long currentMillis = millis();
 
  if(currentMillis - previousMillis > interval) {
    previousMillis = currentMillis;   

    if (ledState == LOW)
      ledState = HIGH;
    else
      ledState = LOW;

    digitalWrite(ledPin, ledState);
  }
  
}

