// sketch for ATLAS Upgrade Interlock II

// Bart Hommels
// University of Cambridge

// 16/7/2012
// V 0.1

// Libraries
//#include <stdlib.h>
#include "Wire.h"// for driving SPI bus and/or I2C/onewire
#include "LiquidCrystal.h"// for LCD on SPI
#include <EEPROM.h>// for using EEPROM
#include "EEPROMAnything.h" // for writing multiple-byte objects to EEPROM
#include <NTCreadout.h>

// pin assignments
const int muxNTC = A0;
const int userNTC09 = A1;
const int userNTC08 = A2;
const int menuPot = A3;

const int muxCtrl0 = 0;
const int muxCtrl1 = 1;
const int muxCtrl2 = 2;
const int menuButton = 3;
const int lcdLatch = 4;
const int lcdClk = 5;
const int lcdData = 6;
const int duoLed = 7;

const int outputEnable = 8;
const int selectRseries = 9;
const int d0_output = 10;
const int d1_output = 11;
const int singleLed = 12;
const int pbEnable = 13;

// constants
const float absTzero = -273.15;// 0 Kelvin in deg C

// 10kOhm hybrid NTCs
const float RseriesHybrid = 10000.0;
const float RrefHybrid = 2000.0;
const float TrefHybrid = 20.0-absTzero;
const float BntcHybrid = 3125.0;

// GL23
//const float RseriesNTC09 = 10000.0;
//const float RrefNTC09 = 2000.0;
//const float TrefNTC09 = 20.0-absTzero;
//const float BntcNTC09 = 3125.0;

// variables
float hybridTHi = 45.0;// deg C
float hybridTLo = 7.0;//deg C
int nSamples = 2;

// instantiations
// SPI LCD interface through 74LS595 shift register
// compatible with LCD serial backpack:
// http://www.ladyada.net/products/i2cspilcdbackpack/index.html
//
// LATCH (p12 on 74LS595)
// CLK (p11 on 74LS595)
// DATA (p14 on 74LS595)
LiquidCrystal lcd(6,5,4);//(data, clk, latch)

// NTC serving MUXed input, user08, user09
NTCtemp hybridNTC;
byte hybridTnotOK = 0x00;
//NTCtemp NTC08;
//NTCtemp NTC09;

void setup(){
  // set mode for all pins
  pinMode(muxCtrl0, OUTPUT);
  pinMode(muxCtrl1, OUTPUT);
  pinMode(muxCtrl2, OUTPUT);
  pinMode(menuButton, INPUT);
  //  pinMode(lcdLatch, OUTPUT);
  //  pinMode(lcdClk, OUTPUT);
  //  pinMode(lcdData, OUTPUT);
  pinMode(duoLed, OUTPUT);
  pinMode(outputEnable, OUTPUT);
  pinMode(selectRseries, OUTPUT);
  pinMode(d0_output, OUTPUT);
  pinMode(d1_output, OUTPUT);
  pinMode(singleLed, OUTPUT);
  pinMode(pbEnable, INPUT);

  // write default outputs to pins
  digitalWrite(muxCtrl0, LOW);
  digitalWrite(muxCtrl1, LOW);
  digitalWrite(muxCtrl2, LOW);

  // use external analog reference
  //analogReference(EXTERNAL);

  // initialise NTC instances
  hybridNTC.setNTCup(muxNTC, nSamples, RseriesHybrid);
  hybridNTC.setNTCParameters(RrefHybrid, TrefHybrid, BntcHybrid);

//  NTC09.setNTC(userNTC09, nSamples, RseriesNTC09);
//  NTC.setNTCParameters(RrefNTC09, TrefNTC09, BntcNTC09);


  // setup lcd + print welcome message
  lcd.begin(40,2);
  lcd.setCursor(11,0);
  lcd.print("Menu demonstrator");
  lcd.setBacklight(HIGH);
  lcd.setCursor(18,1);
  lcd.print("v0.1");

  delay(1000);

  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Temperature");
}


void loop(){
  float hybridTemp[8];
  byte count = 0;

  unsigned long timerlast = millis();

  for(count=0; count < 8; count++){
    digitalWrite(muxCtrl0, (bitRead(count,0) ) );
    digitalWrite(muxCtrl1, (bitRead(count,1) ) );
    digitalWrite(muxCtrl2, (bitRead(count,2) ) );
    hybridTemp[count] = hybridNTC.getDegC();

    if(hybridTemp[count] > hybridTHi || hybridTemp[count] < hybridTLo){ 
      bitWrite(hybridTnotOK, count, HIGH);
    }
    else{
      bitWrite(hybridTnotOK, count, LOW);
    }
  }
 
  unsigned long t_diff = millis()-timerlast;

if(hybridTnotOK == 0){
  digitalWrite(duoLed, LOW);
}
else{
digitalWrite(duoLed, HIGH);
}


for(count = 0; count < 8; count++){
char valTemp[5];
dtostrf(hybridTemp[count], 5, 1, valTemp);
lcd.setCursor((count*5),1);
lcd.print(valTemp);
}


  lcd.setCursor(20,0);
  lcd.print(t_diff);

  lcd.setBacklight(HIGH);
  delay(500);
  lcd.setBacklight(LOW);
  delay(500);


}

// FUNCTIONS

// clear lcd line
void lcdClearLine(int lineNum){
  if(lineNum == 0 || lineNum == 1){
    lcd.setCursor(0,lineNum);
    lcd.print("                                        ");
  }
  return;
}







