// Libraries
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ENTER 13// byte value of the Enter key (LF)

int sumint = 0;
const char dataRequestString[4] = "idr";// Interlock Unit Data Request
const char enableRequestString[4] = "ena";// Enable request

const char* lookup_table[] = {
  "tl","th", "ne", "rn", "tn", "bn", "rl", "rh"};
enum{
  Tlow, Thigh, Nenable, Rnom, Tnom, Bntc, RHlow, RHhigh, None };

byte nBytes = 0; 

void setup(){
  // set up Serial communication (through USB)
  Serial.begin(28800);
  Serial.flush();// clear receive buffer
  sumint = 0;
  nBytes = 0;
}

void loop(){
  int inByte = 0;
  char cmdbuf[4], intbuf[5];
  memset(cmdbuf, '\0', 4);
  memset(intbuf, '\0', 5);

  if(Serial.available()){
    inByte = Serial.read();
    Serial.print((char)inByte);
    if(nBytes < 3) cmdbuf[nBytes] = inByte;
    else if(nBytes < 7) intbuf[nBytes-3] = inByte;
    nBytes++;
    if(inByte == ENTER){
      nBytes = 0;
      Serial.flush();
      Serial.println(" that's all folks. Now figure out what you sent me");

      if(strcmp(cmdbuf, dataRequestString) == 0) Serial.println("Data request received");
      else if(strcmp(cmdbuf, enableRequestString) == 0) Serial.println("Enable request received");
      else{
        switch(cmdbuf[0]){
        case 'h': 
          Serial.print("Hybrid ");
          break;
        case 'u': 
          Serial.print("User   ");
          break;
        case 'r': 
          Serial.print("SHT71  ");
          break;
        default:
          Serial.println("Other...");
          break;
        }

        char setcmd[3];
        for(int i = 0; i<3;i++){
          setcmd[i] = cmdbuf[i+1];
        }
        int convint = atoi(intbuf);
        sumint += convint;

        switch( lookup(setcmd) ){
        case Tlow:
          Serial.print(F("Tlow set to: "));
          Serial.println(float(convint));
          break;
        case Thigh:
          Serial.print("Thigh set to: ");
          Serial.println(float(convint));
          break;
        case Nenable:
          Serial.print("Enable set to: ");
          Serial.println(byte(convint));
          break;
        case Rnom:
          Serial.print("Rnom set to: ");
          Serial.println(convint);
          break;
        case Tnom:
          Serial.print("Tnom set to: ");
          Serial.println(convint);
          break;
        case Bntc:
          Serial.print("Bntc set to: ");
          Serial.println(convint);
          break;
        case RHlow:
          Serial.print("RHlow set to: ");
          Serial.println(float(convint));
          break;
        case RHhigh:
          Serial.print("RHhigh set to: ");
          Serial.println(float(convint));
          break;
        default:
          Serial.println("Command is gibberish. Nothing is set");
          break;
        }// switch lookup(setcmd)


      }// cmd is not data request or enable


    }
  }



}// loop

int lookup(char rxcmd[])
{
  const int ncmds = sizeof lookup_table / sizeof *lookup_table;
  for(int i=0; i!= ncmds; i++)
    if( strcmp(rxcmd, lookup_table[i]) == 0) return i;
  return None;
}






