//  ====================================
//   NAME    : fwUkl1PanelCB
// 
//   VERSION : 3
// 
//   REVISION: 1
// 
//   DATE    : 2008/07/28
// 
//   RELEASE : 2010/01/20
// 
//   PLATFORM: PVSS II
// 
//   AUTHOR  : Gareth Rogers
// 
//   EMAIL   : rogers@hep.phy.cam.ac.uk
//  ====================================

/* \mainpage UKL1PANELCB Contains all the callback functions for each of the abstract registers displayed.
 *
 * These functions are specific to the abstract register that they are parsing and will only work if a shape
 * of the same name is available.
 */

// ====================
//  #USES DECLARATIONS
// ====================

/*! fwUkl1RegisterInterface.ctl provides us with the functions to parse the DPE data. */
#uses "fwUkl1/fwUkl1RegisterInterface.ctl"

/*! fwUkl1ExcepionHandling library is used to store and display errors that occur with fwUkl1 function calls. */
#uses "fwUkl1ExceptionHandling/fwUkl1ExceptionHandling.ctl"

/*!
 * The following functions can be connected to associated hardware register DPE and when the register
 * changes it will place the value of that register in a panel element of the form AbsRegNameField.
 * AbsRegName is the name of the abstract register for example MacDestinationAddress would be
 * MacDestinationAddressField. In the event of an error it will be sent to the error log.
 */
// FPGA configuration registers.
void fwUkl1_MacDestinationAddressCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MacDestinationAddress";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MacDestinationAddressCB()

void fwUkl1_MacSourceAddressCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MacSourceAddress";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MacSourceAddressCB()

void fwUkl1_IpDestinationAddressCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "IpDestinationAddress";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_IpDestinationAddressCB()

void fwUkl1_IpSourceAddressCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "IpSourceAddress";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_CB()

void fwUkl1_PartitionIdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "PartitionId";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_PartitionIdCB()

void fwUkl1_TimeToLiveCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TimeToLive";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TimeToLiveCB()

void fwUkl1_TypeOfServiceCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TypeOfService";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TypeOfServiceCB()

void fwUkl1_ProtocolCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Protocol";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ProtocolCB()

void fwUkl1_TypeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Type";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TypeCB()

void fwUkl1_MepEventCountCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MepEventCount";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MepEventCountCB()

void fwUkl1_MTUCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MTU";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MTUCB()

void fwUkl1_MepTruncationHighWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MepTruncationHighWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MepTruncationHighWatermarkCB()

void fwUkl1_ManualMepGbeOutputPortNumberCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ManualMepGbeOutputPortNumber";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ManualMepGbeOutputPortNumberCB()

void fwUkl1_ThrottleModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ThrottleMode";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ThrottleModeCB()

void fwUkl1_ThrottlePolarityCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ThrottlePolarity";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ThrottlePolarityCB()

void fwUkl1_ThrottleOutputCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ThrottleOutput";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ThrottleOutputCB()

void fwUkl1_ForceFixedMepDestinationAddressCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ForceFixedMepDestinationAddress";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ForceFixedMepDestinationAddressCB()

void fwUkl1_MepBuildingModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MepBuildingMode";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MepBuildingModeCB()

void fwUkl1_TfcDecodingCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TfcDecoding";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_CB()

void fwUkl1_GbeTpaPollingCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTpaPolling";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTpaPollingCB()

void fwUkl1_ManualMepGbeOutputPortControlCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ManualMepGbeOutputPortControl";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ManualMepGbeOutputPortControlCB()

void fwUkl1_Ingress0EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Ingress0Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_Ingress0EnableCB()

void fwUkl1_Ingress1EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Ingress1Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_Ingress1EnableCB()

void fwUkl1_Ingress2EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Ingress2Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_Ingress2EnableCB()

void fwUkl1_Ingress3EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Ingress3Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_Ingress3EnableCB()

void fwUkl1_VersionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "Version";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_VersionCB()

void fwUkl1_TfcLatencyCompensationCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TfcLatencyCompensation";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TfcLatencyCompensationCB()

void fwUkl1_L1IdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "L1Id";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_L1IdCB()

// FPGA status registers.
void fwUkl1_TTCIdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TTCId";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TTCIdCB()

void fwUkl1_TFCFIFORequestCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCFIFORequest";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCFIFORequestCB()

void fwUkl1_TTCrxReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TTCrxReady";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TTCrxReadyCB()

void fwUkl1_EventMergerReadStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EventMergerReadState";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EventMergerReadStateCB()

void fwUkl1_GTDataLowWordInhibit0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLowWordInhibit0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLowWordInhibit0CB()

void fwUkl1_GTDataLowWordInhibit1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLowWordInhibit1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLowWordInhibit1CB()

void fwUkl1_GTDataLowWordInhibit2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLowWordInhibit2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLowWordInhibit2CB()

void fwUkl1_GTDataLowWordInhibit3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLowWordInhibit3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLowWordInhibit3CB()

void fwUkl1_GTDataHighWordInhibit0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataHighWordInhibit0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataHighWordInhibit0CB()

void fwUkl1_GTDataHighWordInhibit1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataHighWordInhibit1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataHighWordInhibit1CB()

void fwUkl1_GTDataHighWordInhibit2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataHighWordInhibit2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataHighWordInhibit2CB()

void fwUkl1_GTDataHighWordInhibit3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataHighWordInhibit3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataHighWordInhibit3CB()

void fwUkl1_GTCommunicationWordInhibit0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTCommunicationWordInhibit0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTCommunicationWordInhibit0CB()

void fwUkl1_GTCommunicationWordInhibit1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTCommunicationWordInhibit1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTCommunicationWordInhibit1CB()

void fwUkl1_GTCommunicationWordInhibit2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTCommunicationWordInhibit2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTCommunicationWordInhibit2CB()

void fwUkl1_GTCommunicationWordInhibit3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTCommunicationWordInhibit3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTCommunicationWordInhibit3CB()

void fwUkl1_GTDataLinkInhibit0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLinkInhibit0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLinkInhibit0CB()

void fwUkl1_GTDataLinkInhibit1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLinkInhibit1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLinkInhibit1CB()

void fwUkl1_GTDataLinkInhibit2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLinkInhibit2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLinkInhibit2CB()

void fwUkl1_GTDataLinkInhibit3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTDataLinkInhibit3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTDataLinkInhibit3CB()

void fwUkl1_GbeTxCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTx";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTxCB()

void fwUkl1_MEPFifoCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MEPFifo";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MEPFifoCB()

void fwUkl1_ThrottleAssertedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ThrottleAsserted";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ThrottleAssertedCB()

void fwUkl1_GTFIFO0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFO0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFO0CB()

void fwUkl1_GTFIFO1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFO1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFO1CB()

void fwUkl1_GTFIFO2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFO2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFO2CB()

void fwUkl1_GTFIFO3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFO3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFO3CB()

void fwUkl1_GTLowFIFODataReadout0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTLowFIFODataReadout0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTLowFIFODataReadout0CB()

void fwUkl1_GTLowFIFODataReadout1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTLowFIFODataReadout1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTLowFIFODataReadout1CB()

void fwUkl1_GTLowFIFODataReadout2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTLowFIFODataReadout2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTLowFIFODataReadout2CB()

void fwUkl1_GTLowFIFODataReadout3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTLowFIFODataReadout3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTLowFIFODataReadout3CB()

void fwUkl1_GTHighFIFODataReadout0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTHighFIFODataReadout0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTHighFIFODataReadout0CB()

void fwUkl1_GTHighFIFODataReadout1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTHighFIFODataReadout1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTHighFIFODataReadout1CB()

void fwUkl1_GTHighFIFODataReadout2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTHighFIFODataReadout2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTHighFIFODataReadout2CB()

void fwUkl1_GTHighFIFODataReadout3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTHighFIFODataReadout3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTHighFIFODataReadout3CB()

void fwUkl1_TFCL0ResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCL0Reset";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCL0ResetCB()

void fwUkl1_TFCL1ResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCL1Reset";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCL1ResetCB()

void fwUkl1_TFCShortBroadcastCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCShortBroadcast";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCShortBroadcastCB()

void fwUkl1_GbeTransmitPortAvailable0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTransmitPortAvailable0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTransmitPortAvailable0CB()

void fwUkl1_GbeTransmitPortAvailable1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTransmitPortAvailable1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTransmitPortAvailable1CB()

void fwUkl1_GbeTransmitPortAvailable2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTransmitPortAvailable2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTransmitPortAvailable2CB()

void fwUkl1_GbeTransmitPortAvailable3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTransmitPortAvailable3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTransmitPortAvailable3CB()

void fwUkl1_EthernetFragmentReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EthernetFragmentReady";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EthernetFragmentReadyCB()

void fwUkl1_MEPReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MEPReady";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MEPReadyCB()

void fwUkl1_FragmentRequestCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "FragmentRequest";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_FragmentRequestCB()

void fwUkl1_MEPExtractionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MEPExtraction";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MEPExtractionCB()

void fwUkl1_EthernetFormatterStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EthernetFormatterState";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EthernetFormatterStateCB()

void fwUkl1_FragmentExtractionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "FragmentExtraction";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_FragmentExtractionCB()

void fwUkl1_SequenceErrorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "SequenceError";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_SequenceErrorCB()

void fwUkl1_MEPCountCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MEPCount";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MEPCountCB()

void fwUkl1_GTFIFOTxWait0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFOTxWait0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFOTxWait0CB()

void fwUkl1_GTFIFOTxWait1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFOTxWait1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFOTxWait1CB()

void fwUkl1_GTFIFOTxWait2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFOTxWait2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFOTxWait2CB()

void fwUkl1_GTFIFOTxWait3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GTFIFOTxWait3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GTFIFOTxWait3CB()

void fwUkl1_TFCFIFOOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCFIFOOccupancy";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCFIFOOccupancyCB()

void fwUkl1_TFCLongBroadcastCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCLongBroadcast";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCLongBroadcastCB()

void fwUkl1_EgressInputFIFOLowWordSequenceError0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordSequenceError0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordSequenceError0CB()

void fwUkl1_EgressInputFIFOLowWordSequenceError1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordSequenceError1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordSequenceError1CB()

void fwUkl1_EgressInputFIFOLowWordSequenceError2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordSequenceError2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordSequenceError2CB()

void fwUkl1_EgressInputFIFOLowWordSequenceError3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordSequenceError3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordSequenceError3CB()

void fwUkl1_EgressInputFIFOHighWordSequenceError0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordSequenceError0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordSequenceError0CB()

void fwUkl1_EgressInputFIFOHighWordSequenceError1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordSequenceError1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordSequenceError1CB()

void fwUkl1_EgressInputFIFOHighWordSequenceError2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordSequenceError2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordSequenceError2CB()

void fwUkl1_EgressInputFIFOHighWordSequenceError3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordSequenceError3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordSequenceError3CB()

void fwUkl1_L0TriggerCountCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "L0TriggerCount";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_L0TriggerCountCB()

void fwUkl1_ROTBroadcastCountCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ROTBroadcastCount";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ROTBroadcastCountCB()

void fwUkl1_TFCDestinationCountCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TFCDestinationCount";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TFCDestinationCountCB()

void fwUkl1_MEPSequenceCountCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "MEPSequenceCount";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_MEPSequenceCountCB()

void fwUkl1_TTCrxReadyAlarmCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TTCrxReadyAlarm";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TTCrxReadyAlarmCB()

void fwUkl1_SequenceErrorAlarmCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "SequenceErrorAlarm";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_SequenceErrorAlarmCB()

void fwUkl1_EgressInputFIFOLowWordOccupancy0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordOccupancy0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordOccupancy0CB()

void fwUkl1_EgressInputFIFOLowWordOccupancy1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordOccupancy1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordOccupancy1CB()

void fwUkl1_EgressInputFIFOLowWordOccupancy2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordOccupancy2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordOccupancy2CB()

void fwUkl1_EgressInputFIFOLowWordOccupancy3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordOccupancy3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordOccupancy3CB()

void fwUkl1_EgressInputFIFOHighWordOccupancy0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordOccupancy0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordOccupancy0CB()

void fwUkl1_EgressInputFIFOHighWordOccupancy1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordOccupancy1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordOccupancy1CB()

void fwUkl1_EgressInputFIFOHighWordOccupancy2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordOccupancy2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordOccupancy2CB()

void fwUkl1_EgressInputFIFOHighWordOccupancy3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordOccupancy3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordOccupancy3CB()

void fwUkl1_EgressInputFIFOLowWordRxCount0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordRxCount0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordRxCount0CB()

void fwUkl1_EgressInputFIFOLowWordRxCount1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordRxCount1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordRxCount1CB()

void fwUkl1_EgressInputFIFOLowWordRxCount2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordRxCount2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordRxCount2CB()

void fwUkl1_EgressInputFIFOLowWordRxCount3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordRxCount3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordRxCount3CB()

void fwUkl1_EgressInputFIFOHighWordRxCount0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordRxCount0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordRxCount0CB()

void fwUkl1_EgressInputFIFOHighWordRxCount1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordRxCount1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordRxCount1CB()

void fwUkl1_EgressInputFIFOHighWordRxCount2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordRxCount2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordRxCount2CB()

void fwUkl1_EgressInputFIFOHighWordRxCount3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordRxCount3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordRxCount3CB()

void fwUkl1_EgressInputFIFOLowWordTxCount0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordTxCount0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordTxCount0CB()

void fwUkl1_EgressInputFIFOLowWordTxCount1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordTxCount1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordTxCount1CB()

void fwUkl1_EgressInputFIFOLowWordTxCount2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordTxCount2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordTxCount2CB()

void fwUkl1_EgressInputFIFOLowWordTxCount3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOLowWordTxCount3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOLowWordTxCount3CB()

void fwUkl1_EgressInputFIFOHighWordTxCount0CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordTxCount0";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordTxCount0CB()

void fwUkl1_EgressInputFIFOHighWordTxCount1CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordTxCount1";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordTxCount1CB()

void fwUkl1_EgressInputFIFOHighWordTxCount2CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordTxCount2";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordTxCount2CB()

void fwUkl1_EgressInputFIFOHighWordTxCount3CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "EgressInputFIFOHighWordTxCount3";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_EgressInputFIFOHighWordTxCount3CB()

// ID registers.
void fwUkl1_SerialNumberCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "SerialNumber";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_SerialNumberCB()

void fwUkl1_LogicalIdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "LogicalId";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_LogicalIdCB()

void fwUkl1_RichIdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "RichId";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_RichIdCB()

// Sensors.
void fwUkl1_TemperatureSensorTopCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TemperatureSensorTop";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TemperatureSensorTopCB()

void fwUkl1_TemperatureSensorMiddleCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TemperatureSensorMiddle";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TemperatureSensorMiddleCB()

void fwUkl1_TemperatureSensorBottomCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TemperatureSensorBottom";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TemperatureSensorBottomCB()

// TTCrx.
void fwUkl1_TtcrxDoubleErrorCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TtcrxDoubleErrorCounter";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TtcrxDoubleErrorCounterCB()

void fwUkl1_TtcrxSingleErrorCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TtcrxSingleErrorCounter";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TtcrxSingleErrorCounterCB()

void fwUkl1_TtcrxSEUErrorCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TtcrxSEUErrorCounter";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TtcrxSEUErrorCounterCB()

void fwUkl1_TtcrxStatusCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TtcrxStatus";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TtcrxStatusCB()

void fwUkl1_TtcrxControlCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "TtcrxControl";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_TtcrxControlCB()

void fwUkl1_GbeJtagIdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeJtagId";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeJtagIdCB()

void fwUkl1_GbeMACSoftResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeMACSoftReset";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeMACSoftResetCB()

void fwUkl1_GbeReceivePortResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeReceivePortReset";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeReceivePortResetCB()

void fwUkl1_GbeTransmitPortResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeTransimitPortReset";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeTransimitPortResetCB()

void fwUkl1_GbeReceiveFifoEnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeReceiveFifoEnable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeReceiveFifoEnableCB()

void fwUkl1_GbeModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeMode";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeModeCB()

void fwUkl1_GbeClockCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeClock";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeClockCB()

void fwUkl1_GbeSPI3ConfigTrnmtGlobalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeSPI3ConfigTrnmtGlobal";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeSPI3ConfigTrnmtGlobalCB()

void fwUkl1_GbeSPI3ConfigRcvCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeSPI3ConfigRcv";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeSPI3ConfigRcvCB()

void fwUkl1_GbeRxStatusCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeRxStatus";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeRxStatusCB()

void fwUkl1_GbePHYCtrlCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePHYCtrl";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePHYCtrlCB()

void fwUkl1_GbePHYWriteDataCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePHYWriteData";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePHYWriteDataCB()

void fwUkl1_GbePHYReadDataCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePHYReadData";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePHYReadDataCB()

void fwUkl1_GbeMDIOControlCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbeMDIOControl";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbeMDIOControlCB()

void fwUkl1_GbePort0EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort0Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort0EnableCB()

void fwUkl1_GbePort1EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort1Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort1EnableCB()

void fwUkl1_GbePort2EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort2Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort2EnableCB()

void fwUkl1_GbePort3EnableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort3Enable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort3EnableCB()

void fwUkl1_GbePort0TxFifoThresholdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort0TxFifoThreshold";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort0TxFifoThresholdCB()

void fwUkl1_GbePort1TxFifoThresholdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort1TxFifoThreshold";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort1TxFifoThresholdCB()

void fwUkl1_GbePort2TxFifoThresholdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort2TxFifoThreshold";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort2TxFifoThresholdCB()

void fwUkl1_GbePort3TxFifoThresholdCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort3TxFifoThreshold";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort3TxFifoThresholdCB()

void fwUkl1_GbePort0TxFifoLowWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort0TxFifoLowWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort0TxFifoLowWatermarkCB()

void fwUkl1_GbePort1TxFifoLowWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort1TxFifoLowWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort1TxFifoLowWatermarkCB()

void fwUkl1_GbePort2TxFifoLowWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort2TxFifoLowWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort2TxFifoLowWatermarkCB()

void fwUkl1_GbePort3TxFifoLowWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort3TxFifoLowWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort3TxFifoLowWatermarkCB()

void fwUkl1_GbePort0TxFifoHighWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort0TxFifoHighWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort0TxFifoHighWatermarkCB()

void fwUkl1_GbePort1TxFifoHighWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort1TxFifoHighWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort1TxFifoHighWatermarkCB()

void fwUkl1_GbePort2TxFifoHighWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort2TxFifoHighWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort2TxFifoHighWatermarkCB()

void fwUkl1_GbePort3TxFifoHighWatermarkCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "GbePort3TxFifoHighWatermark";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_GbePort3TxFifoHighWatermarkCB()
    
void fwUkl1_Channel00DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35DisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35Disable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35HpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35HpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35ZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35ZeroSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35EmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35EmptyHpdSuppression";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35PixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35PixelMasks";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35EmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35Emulator";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35EmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35EmulatorHpdPixelMode";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}
// Harry
void fwUkl1_Channel00FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35FastResettableChannelInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35FastResettableChannelInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

// Harry
void fwUkl1_Channel00EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel01EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel02EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel03EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel04EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel05EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel06EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel07EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel08EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel09EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel10EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel11EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel12EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel13EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel14EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel15EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel16EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel17EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel18EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel19EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel20EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel21EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel22EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel23EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel24EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel25EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel26EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel27EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel28EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel29EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel30EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel31EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel32EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel33EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel34EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel35EmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35EmulatorEvent";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
}

void fwUkl1_Channel00SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35SoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35SoftDisable";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_ChannelAllDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllDisable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllDisableCB()

void fwUkl1_ChannelAllHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllHpdPixelMode";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllHpdPixelModeCB()

void fwUkl1_ChannelAllZeroSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllZeroSuppression";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllZeroSuppressionCB()

void fwUkl1_ChannelAllEmptyHpdSuppressionCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllEmptyHpdSuppression";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllEmptyHpdSuppressionCB()

void fwUkl1_ChannelAllPixelMasksCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllPixelMasks";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllPixelMasksCB()

void fwUkl1_ChannelAllEmulatorCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllEmulator";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllEmulatorCB()

void fwUkl1_ChannelAllEmulatorHpdPixelModeCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllEmulatorHpdPixelMode";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllEmulatorHpdPixelModeCB()

void fwUkl1_ChannelAllEmulatorEventCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllEmulatorEvent";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllEmulatorEventCB()

void fwUkl1_ChannelAllSoftDisableCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  // The abstract register we are dealing with.
  const string absRegName = "ChannelAllSoftDisable";
  // UKL1 name is returned by this function.
  string ukl1Name;
  // Now call the function that will parse this data.
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
  return;
}// fwUkl1_ChannelAllSoftDisableCB()

void fwUkl1_Channel00OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35OpticalReceiverStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35OpticalReceiverState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35OpticalRxBufferStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35OpticalRxBufferState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35OpticalRxDisparityErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35OpticalRxDisparityErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35OpticalRxBufferErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35OpticalRxBufferErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35OpticalRxClockCorrectionsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35OpticalRxClockCorrections";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35ZeroSuppressionInBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35ZeroSuppressionInBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35ZeroSuppressionOutBufferCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35ZeroSuppressionOutBuffer";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35ZeroSuppressionBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35ZeroSuppressionBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35ZeroSuppressionACounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35ZeroSuppressionACounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35ZeroSuppressionBCounterCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35ZeroSuppressionBCounter";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35IngressBufferReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35IngressBufferReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35IngressBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35IngressBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35IngressBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35IngressBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35CosynchronisorStateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35CosynchronisorState";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35CosynchronisorErrorsCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35CosynchronisorErrors";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35TimeOfArrivalCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35TimeOfArrival";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel00StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel00State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel01StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel01State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel02StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel02State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel03StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel03State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel04StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel04State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel05StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel05State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel06StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel06State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel07StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel07State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel08StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel08State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel09StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel09State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel10StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel10State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel11StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel11State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel12StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel12State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel13StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel13State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel14StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel14State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel15StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel15State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel16StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel16State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel17StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel17State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel18StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel18State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel19StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel19State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel20StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel20State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel21StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel21State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel22StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel22State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel23StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel23State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel24StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel24State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel25StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel25State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel26StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel26State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel27StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel27State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel28StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel28State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel29StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel29State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel30StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel30State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel31StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel31State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel32StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel32State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel33StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel33State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel34StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel34State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Channel35StateCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Channel35State";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0ResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0Reset";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1ResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1Reset";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2ResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2Reset";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3ResetCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3Reset";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0ReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0Ready";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1ReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1Ready";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2ReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2Ready";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3ReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3Ready";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0DcmUpLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0DcmUpLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1DcmUpLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1DcmUpLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2DcmUpLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2DcmUpLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3DcmUpLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3DcmUpLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0DcmDownLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0DcmDownLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1DcmDownLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1DcmDownLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2DcmDownLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2DcmDownLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3DcmDownLockedCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3DcmDownLocked";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0DcmsNotReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0DcmsNotReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1DcmsNotReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1DcmsNotReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2DcmsNotReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2DcmsNotReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3DcmsNotReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3DcmsNotReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0GTDataLowWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0GTDataLowWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1GTDataLowWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1GTDataLowWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2GTDataLowWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2GTDataLowWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3GTDataLowWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3GTDataLowWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0GTDataHighWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0GTDataHighWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1GTDataHighWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1GTDataHighWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2GTDataHighWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2GTDataHighWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3GTDataHighWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3GTDataHighWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0GTDataCommunicationWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0GTDataCommunicationWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1GTDataCommunicationWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1GTDataCommunicationWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2GTDataCommunicationWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2GTDataCommunicationWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3GTDataCommunicationWordInhibitCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3GTDataCommunicationWordInhibit";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0EgressBusyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0EgressBusy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1EgressBusyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1EgressBusy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2EgressBusyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2EgressBusy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3EgressBusyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3EgressBusy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0MrxSignalDetectCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0MrxSignalDetect";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1MrxSignalDetectCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1MrxSignalDetect";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2MrxSignalDetectCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2MrxSignalDetect";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3MrxSignalDetectCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3MrxSignalDetect";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0TfcFifoDataReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0TfcFifoDataReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1TfcFifoDataReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1TfcFifoDataReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2TfcFifoDataReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2TfcFifoDataReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3TfcFifoDataReadyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3TfcFifoDataReady";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0TfcFifoBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0TfcFifoBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1TfcFifoBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1TfcFifoBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2TfcFifoBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2TfcFifoBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3TfcFifoBufferFullCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3TfcFifoBufferFull";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0TfcFifoBufferInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0TfcFifoBufferIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1TfcFifoBufferInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1TfcFifoBufferIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2TfcFifoBufferInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2TfcFifoBufferIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3TfcFifoBufferInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3TfcFifoBufferIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0TfcFifoBufferOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0TfcFifoBufferOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1TfcFifoBufferOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1TfcFifoBufferOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2TfcFifoBufferOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2TfcFifoBufferOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3TfcFifoBufferOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3TfcFifoBufferOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0TfcFifoBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0TfcFifoBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1TfcFifoBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1TfcFifoBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2TfcFifoBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2TfcFifoBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3TfcFifoBufferOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3TfcFifoBufferOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0EventFifoInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0EventFifoIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1EventFifoInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1EventFifoIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2EventFifoInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2EventFifoIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3EventFifoInCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3EventFifoIn";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress0EventFifoOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0EventFifoOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1EventFifoOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1EventFifoOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2EventFifoOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2EventFifoOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3EventFifoOutCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3EventFifoOut";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}
void fwUkl1_Ingress0EventFifoOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress0EventFifoOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress1EventFifoOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress1EventFifoOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress2EventFifoOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress2EventFifoOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}

void fwUkl1_Ingress3EventFifoOccupancyCB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
  dyn_string exceptionInfo;
  int exInfoSize = 0;
  const string absRegName = "Ingress3EventFifoOccupancy";
  string ukl1Name;
  _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
  fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_"+absRegName+"CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
}
// [INSERT HERE]

// void fwUkl1_CB(const dyn_string &dpeNames, const dyn_dyn_char &ddcNewValues) {
//   dyn_string exceptionInfo;
//   int exInfoSize = 0;
  // The abstract register we are dealing with.
//   const string absRegName = "";
  // UKL1 name is returned by this function.
//   string ukl1Name;
  // Now call the function that will parse this data.
//   _fwUkl1_parseRegisterForCallback(absRegName, dpeNames, ddcNewValues, ukl1Name, exceptionInfo);
//   fwUkl1Exception_checkAndRaise(exceptionInfo, "WARNING", "fwUkl1_" + absRegName + "CB(): Could not parse and display the updated value for this register. Shape not updated.", "2", exInfoSize);
  // The UKL1 name is the bit before the first full stop in the DPE name. Leave the system name in.
//   fwUkl1ExceptionLog_submit(exceptionInfo, ukl1Name);
  // Done.
//   return;
// }// fwUkl1_CB()

// ============
//   INTERNAL
// ============

/*!
 * This function takes the abstract register name and the data from the hardware register that contains the value(s)
 * for the hardware register(s) and displays the abstract register value on a panel shape.
 *
 * @param  absRegName Abtract register name that the new value is to be retrieved for.
 * @param  dpeNames Names of the DPE that the updated hardware register data has come from.
 * @param  ddcNewValues The updated data in the hardware register(s) that need to be parsed.
 * @param  ukl1Name Name of the UKL1 board as found in the DIM server that is retrieved from the first DPE name.
 *           Returned by reference.
 * @param  exceptionInfo Error information. No change in size if no exception information is generated.
 * @return void.
 *
 * This function contains all the generic parsing that is required by the individual abstract register
 * callback functions. They simply need to define the register that they want the data for and pass on
 * that data they were given by when called and this function will sort the rest out.
 */
void _fwUkl1_parseRegisterForCallback(const string &absRegName, dyn_string dpeNames, dyn_dyn_char ddcNewValues, string &ukl1Name, dyn_string &exceptionInfo) {
  string sys = fwUkl1_removeDeviceName(dpeNames[1]);  

  int exInfoSize = dynlen(exceptionInfo);
  // Call the function that will deal with the data parsing for us.
  mapping outData = fwUkl1_readDPEs(makeDynString(sys+absRegName), dpeNames, ddcNewValues, exceptionInfo);
  if (!fwUkl1Exception_checkAndRaise(exceptionInfo, "ERROR", "_fwUkl1_parseRegisterForCallback(): Failed to convert the DPE data to the parsed for to disable to panel shape for the abstract register "+absRegName+".", "2", exInfoSize)) {
    // We know what shape name we want to put the data on.
    const string shapeName = absRegName + "Field";
    // Check if it exists.
    if (shapeExists(shapeName)) {
      shape sh = getShape(shapeName);
      sh.text(outData[sys+absRegName][FWUKL1_MAP_REG_DATA]);
      sh.backCol(outData[sys+absRegName][FWUKL1_MAP_XTR_DATA]);
      if (""!=outData[sys+absRegName][FWUKL1_MAP_XTR_DATA+1]) {
        sh.toolTipText(outData[sys+absRegName][FWUKL1_MAP_XTR_DATA+1]);
      }// if given new tool tip text
    }// if shapeExists()
    else
      exInfoSize = fwUkl1Exception_raise(exceptionInfo, "WARNING", "_fwUkl1_parseRegisterForCallback(): Could not find the shape " + shapeName + " to display the data " + outData[sys+absRegName][FWUKL1_MAP_REG_DATA] + ".", "2");
    
    // Get the UKL1 name from the first dpe name in the list.
    if (0 < dynlen(dpeNames)) {
      // The UKL1 name is up to the first full stop.
      const int endOfUkl1Name = strpos(dpeNames[1], ".");
      // Get the UKL1 name while we are here.
      ukl1Name = substr(dpeNames[1], 0, endOfUkl1Name);
    }// if(0<dynlen(dpeNames))
  }// if parsed DPE data.
  // Done.
  return;
}// _fwUkl1_parseRegisterForCallback()
