package SummaryReader;
/*
 * @author robinson
 */
import java.util.Vector;


public class Test {

      String[] dataValues;
      Vector comments;
      String noDefects;
      String testStatus;
      Vector dataBlockList;
      Vector defectList;
      TestInfo testInfo;
      DAQInfo daqInfo;
      ScanInfo scanInfo;
      LinkInfo linkInfo=null;
      DCSInfo dcsInfo=null;
      IVData ivData;

      String testType;
      String serialNo;

      public Test() {

        dataValues = new String[12];
        dataBlockList = new Vector();
        defectList = new Vector();
        comments = new Vector();
        ivData=null;
    }

    public void add(DataBlock dataBlock) {
        dataBlock.calculateMeans();
        dataBlockList.add(dataBlock);
        }
    public void add(DefectInfo defectInfo) {
        defectList.add(defectInfo);
        }
    public void add(TestInfo testInfo) {
        this.testInfo=testInfo;
       }
    public void add(ScanInfo info) {
        this.scanInfo = info;
       }
    public void add(LinkInfo info) {
        this.linkInfo = info;
       }
    public void add(DAQInfo daqInfo) {
        this.daqInfo=daqInfo;
       }
    public void add(DCSInfo dcsInfo) {
        this.dcsInfo=dcsInfo;
        }
    public void add(IVData ivData) {
        this.ivData = ivData;
        }
    public DCSInfo getDCSInfo() {
        return dcsInfo;
       }
    public TestInfo getTestInfo() {
        return testInfo;
       }
    public DAQInfo getDAQInfo() {
        return daqInfo;
        }
    public ScanInfo getScanInfo() {
        return scanInfo;
        }
    public LinkInfo getLinkInfo() {
        return linkInfo;
        }
    public IVData getIVData() {
        return ivData;
        }
    public int noDataBlocks() {
        return dataBlockList.size();
        }
    public DataBlock getDataBlock(int index) {
        return (DataBlock)dataBlockList.elementAt(index);
        }
    public DataBlock getLastDataBlock() {
        return (DataBlock)dataBlockList.lastElement();
        }
    public Double noDefects() {
        return new Double(defectList.size());
        }
    public DefectInfo getDefectInfo(int index) {
        return (DefectInfo)defectList.elementAt(index);
        }
    public String getDefectSummaryTable() {
       StringBuffer table = new StringBuffer("<h3>Defect Info</h3>\n");
       if(defectList.size()==0) {
           table.append("No defects");
           return table.toString();
           }
       table.append("<table border=1>\n");
       table.append("<tr><td>Channel(s)</td><td>Defect</td></tr>\n");
       for(int i=0;i<defectList.size();i++) {
           DefectInfo defectInfo = (DefectInfo)defectList.elementAt(i);
           String chan1 = defectInfo.getFirstChannel();
           String chan2 = defectInfo.getLastChannel();
           String channel = (chan1.equals(chan2)) ? chan1 : chan1+"-"+chan2;
           table.append("<tr><td>"+channel+"</td><td>"+defectInfo.getName()+"</td></tr>");
           }
       table.append("</table>\n");
       return table.toString();
       }
    public void setTestType(String type) {
       this.testType=testType;
       }
    public void addDefectStripCount(String noDefects) {
       this.noDefects=noDefects;
       }
    public void addTestStatus(String testStatus) {
       this.testStatus=testStatus;
       }
    public String getTestStatus() {
        if(testStatus==null) return null;
        return testStatus;
        }
    public String getDefectiveStripCount() {
        if(noDefects==null) return null;
        else return noDefects;
        }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
        }
    public String getSerialNo() {
         return serialNo;
         }


    public void setData(int index, String value) {
        dataValues[index]=value;
        }
    public String getData(int index) {
        index--;
        if(index==-1) {
          double maxValue=0.;
          for(int i=0;i<dataValues.length;i++) {
             double thisValue = Double.parseDouble(dataValues[i]);
             if(thisValue>maxValue) maxValue=thisValue;
             }
          return Double.toString(maxValue);
          }
        return dataValues[index];
        }
    public void addComment(String comment) {
        comments.addElement(comment);
        }
    public String getComment(int commentIndex) {
        return (String)comments.elementAt(commentIndex);
        }
    public String getCommentsSummary() {
       StringBuffer table = new StringBuffer("<h3>Comments</h3>\n");
       if(comments.size()==0) {
           table.append("None");
           return table.toString();
           }
       for(int i=0;i<comments.size();i++) table.append((String)comments.elementAt(i)+"\n");
       return table.toString();
       }
        


}
