package SummaryReader;
import java.io.*;

public class ReaderReportUtilities  {
          public static void showTestReport(String sn, Test testResult) {
           StringBuffer htmlReport = new StringBuffer(guiUtilities.DaveUtils.getHTMLHeader("Test Report for "+sn));
           htmlReport.append(testResult.getTestInfo().getSummaryTable());
           htmlReport.append(testResult.getCommentsSummary());
           htmlReport.append(testResult.getDAQInfo().getSummaryTable());
           htmlReport.append(testResult.getScanInfo().getSummaryTable());
           DCSInfo dcsInfo = testResult.getDCSInfo();
           if(dcsInfo!=null) htmlReport.append(dcsInfo.getSummaryTable());
           else htmlReport.append("<h3>DCS Info</h3>No DCS information available.\n");
           LinkInfo linkInfo = testResult.getLinkInfo();
           if(linkInfo==null) {
             int dataBlocks=testResult.noDataBlocks();
             if(dataBlocks==0) htmlReport.append("<br>No chip data available<br>");
             else for(int i=0;i<testResult.noDataBlocks();i++) htmlReport.append(testResult.getDataBlock(i).getSummaryTable());
             }
           else htmlReport.append(linkInfo.getSummaryTable());
           htmlReport.append(testResult.getDefectSummaryTable());
           htmlReport.append(guiUtilities.DaveUtils.getHTMLFooter());
           guiUtilities.HTMLViewer.getInstance().show(htmlReport.toString(),testResult.getTestInfo().getName()+" Report for "+sn);
           }
          public static void showIVTestReport(String sn, Test testResult) {
           StringBuffer htmlReport = new StringBuffer(guiUtilities.DaveUtils.getHTMLHeader("IVScan Report for "+sn));
           htmlReport.append(testResult.getTestInfo().getSummaryTable());
           DCSInfo dcsInfo = testResult.getDCSInfo();
           if(dcsInfo!=null) htmlReport.append(dcsInfo.getSummaryTable());
           else htmlReport.append("<br>No DCS information available.");
           htmlReport.append(testResult.getIVData().getSummaryTable());

           htmlReport.append(guiUtilities.DaveUtils.getHTMLFooter());
           guiUtilities.HTMLViewer.getInstance().show(htmlReport.toString(),testResult.getTestInfo().getName()+" Report for "+sn);
           }
}
