package ProdDatabase;

import java.io.*;
import java.util.*;
import java.sql.*;
import guiUtilities.*;
/*
 * ReportDownloader.java
 *
 */

/**
 *
 * @author  robinson
 */
public class ReportDownloader extends Thread {
    int reportType;
    String parameter1;
    int parameter2;
//    HTMLViewer htmlViewer;
    Vector deviceList;
    boolean alreadyRunning=false;
    private final String thisThreadName = "SCTDB_DOWNLOAD";
//    public static final int SCTDB_TEST_REPORT=0;
//    public static final int SCTDB_MODULE_REPORT=1;
//    public static final int SCTDB_SENSORS_REPORT=2;
//    public static final int POSTSCRIPT_FILE=3;

//    public ReportDownloader(int reportType, String parameter1, int parameter2, HTMLViewer htmlViewer) {
    public ReportDownloader(int reportType, String parameter1, int parameter2) {
         super("SCTDB_DOWNLOAD");
         this.reportType=reportType;
         this.parameter1=parameter1;
         this.parameter2=parameter2;
//         this.htmlViewer=htmlViewer;

         setPriority(Thread.MIN_PRIORITY);

         }
//    public ReportDownloader(int reportType, Vector deviceList, HTMLViewer htmlViewer) {
    public ReportDownloader(int reportType, Vector deviceList) {
         super("SCTDB_DOWNLOAD");
         this.reportType=reportType;
         this.deviceList = deviceList;
//         this.htmlViewer=htmlViewer;

         setPriority(Thread.MIN_PRIORITY);

         }
    public boolean isOkToStart() {
         Thread[] allThreads = new Thread[Thread.activeCount()];
         Thread.enumerate(allThreads);
         for(int i=0;i<allThreads.length;i++) {
            if(allThreads[i]!=null && allThreads[i].getName().equals("SCTDB_DOWNLOAD") && allThreads[i].isAlive()) {
                  System.out.println("***A download from SCTDB is already in progress. Please wait...");
                  return false;
                  }
            }
         return true;
         }

    public void run() {
         StringBuffer htmlContent = new StringBuffer();
         switch(reportType) {
            case guiUtilities.HTMLViewer.SCTDAQTESTDATA:
             String testno=parameter1;
             SctDaqTestInfo testInfo;
             try {
               if((testInfo=HTMLReportUtilities.getHTMLTestInfo(parameter1))==null) {
                   javax.swing.JOptionPane.showMessageDialog(null,"No SCTDB data for this test number","No Data",javax.swing.JOptionPane.INFORMATION_MESSAGE);
                   return;
                   }
               htmlContent.append(guiUtilities.DaveUtils.getHTMLHeader(testInfo.getInfoString()));
               htmlContent.append(testInfo.getInfoString());
               htmlContent.append(HTMLReportUtilities.getHTMLCommentsTable(testno));
               htmlContent.append(HTMLReportUtilities.getHTMLDAQTable(testno));
               htmlContent.append(HTMLReportUtilities.getHTMLDCSTable(testno));
               htmlContent.append(HTMLReportUtilities.getHTMLScanTable(testno));
               htmlContent.append(HTMLReportUtilities.getSCTDAQHTMLTestData(testno,testInfo.getTestIndex()));
               htmlContent.append(HTMLReportUtilities.getHTMLDefectTable(testno));
               htmlContent.append(HTMLReportUtilities.getHTMLPlotTable(testno));
               htmlContent.append(HTMLReportUtilities.getImageHTMLTable(testno));
               htmlContent.append(guiUtilities.DaveUtils.getHTMLFooter());
               HTMLViewer.getInstance().show(htmlContent.toString(),testInfo.getInfoString());
             }catch(Exception e) {System.out.println("Exception writing html report: "+e.toString());};
             break;
            case guiUtilities.HTMLViewer.SCTDAQTESTLIST:
             String[] info = parameter1.split("__");
// parameter1 is serno+"__"+sctdaq.getLocation()+"__"+sctdaq.getDate()+"__"+temperature
             String title = (info.length==1) ? "SCTDAQ Tests of "+info[0] : info[3]+" SCTDAQ Tests of "+info[0]+" at "+info[1]+" on "+info[2];
             try {
               htmlContent.append(guiUtilities.DaveUtils.getHTMLHeader(title));
               htmlContent.append(HTMLReportUtilities.getHTMLModuleSummaryData(parameter1));
               htmlContent.append(guiUtilities.DaveUtils.getHTMLFooter());
               HTMLViewer.getInstance().show(htmlContent.toString(),title);
             }catch(Exception e) {System.out.println("Exception writing html report: "+e.toString());};
             break;
            case guiUtilities.HTMLViewer.MODULESUMMARY:
             String modSummary;
             if((modSummary=HTMLReportUtilities.getModuleReport(parameter1))==null) return;
             HTMLViewer.getInstance().show(modSummary,"Summary Report for Module "+parameter1);
             break;
            case guiUtilities.HTMLViewer.SENSORTESTDATA:
               if(deviceList.size()<1) return;
               StringBuffer sensorList = new StringBuffer((String)deviceList.elementAt(0));
               for(int i=1;i<deviceList.size();i++) sensorList.append(","+(String)deviceList.elementAt(i));
               try {
                 htmlContent.append(guiUtilities.DaveUtils.getHTMLHeader("Test Report for Sensor(s) "+sensorList.toString()));
                 htmlContent.append(HTMLReportUtilities.getSensorMfrHTMLTable(deviceList));
                 htmlContent.append(HTMLReportUtilities.getSensorIVHTMLTable(deviceList));
                 htmlContent.append(HTMLReportUtilities.getSensorDepletionHTMLTable(deviceList));
                 htmlContent.append(HTMLReportUtilities.getSensorDefectHTMLTable(deviceList));
                 htmlContent.append(HTMLReportUtilities.getSensorVisualTestHTMLTable(deviceList));
                 htmlContent.append(guiUtilities.DaveUtils.getHTMLFooter());
                 HTMLViewer.getInstance().show(htmlContent.toString(),"Sensor Test Report for "+sensorList.toString());
               }catch(Exception e2) {System.out.println("ERROR: Exception writing sensor test report: "+e2.toString());};
               break;
            case guiUtilities.HTMLViewer.URLTOPOSTSCRIPT:
                try {
                   GeneralUtilities.downloadPSFile(null,new java.net.URL(parameter1));
                }catch(Exception e3) {System.out.println("ERROR: Exception downloading/displaying postscript: "+e3.toString());};
                break;
            case guiUtilities.HTMLViewer.RAWDATA: 
                try {
                   if((testInfo=HTMLReportUtilities.getHTMLTestInfo(parameter1))==null) {
                     javax.swing.JOptionPane.showMessageDialog(null,"No SCTDB data for this test number","No Data",javax.swing.JOptionPane.INFORMATION_MESSAGE);
                     return;
                     }
                Vector theRawData = GeneralUtilities.getRawData(parameter1);
                if(theRawData.size()>0) {
                   testInfo = HTMLReportUtilities.getHTMLTestInfo(parameter1);
                   RawDataViewer.getInstance().showNewData(theRawData,"Raw Data for "+testInfo.getInfoString());
                   }
                 }catch(Exception e4) {System.out.println("ERROR: Exception downloading raw data: "+e4.toString());};
                 break;

          default:
          }
     }


}
